/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jdk;

import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.ClassPool;
import org.nudge.javassist.CtClass;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.log.Logger;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.ClassDef;

public class RuntimeWeaver
extends AbstractWeaver {
    private static final Logger log = Logger.getLogger("org.nudge");

    @Override
    public boolean matches(ClassDef clazz, ClassLoader cl) {
        return "java/lang/Runtime".equals(clazz.getName());
    }

    @Override
    public boolean instrument(CtMethod method) throws CannotCompileException, NotFoundException {
        return false;
    }

    private void doRuntimeInstrumetation(ClassPool cp) {
        try {
            CtClass clazz = cp.getCtClass("java.lang.Runtime");
            for (CtMethod m : clazz.getMethods()) {
                CtClass[] exceptions;
                if (!m.getName().equals("exec")) continue;
                StringBuffer buf = new StringBuffer(1000);
                buf.append("{ ");
                buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
                buf.append("  logger.enteringRuntimeExec(); ");
                buf.append("} ");
                m.insertAfter(buf.toString(), true);
                for (CtClass e : exceptions = m.getExceptionTypes()) {
                    buf = new StringBuffer(500);
                    buf.append("{ ");
                    buf.append("   org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
                    buf.append("   logger.logErrorRuntimeExec(); ");
                    buf.append("   throw $e; ");
                    buf.append("} ");
                    m.addCatch(buf.toString(), e);
                }
                buf = new StringBuffer(1000);
                buf.append("{ ");
                buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
                buf.append("  logger.exitingRuntimeExec($1); ");
                buf.append("} ");
                m.insertAfter(buf.toString(), true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

