/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jdk;

import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.ClassPool;
import org.nudge.javassist.CtClass;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.log.Logger;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.ClassDef;

public class SocketWeaver
extends AbstractWeaver {
    private static final Logger log = Logger.getLogger("org.nudge");

    @Override
    public boolean matches(ClassDef clazz, ClassLoader cl) {
        return "java/net/Socket".equals(clazz.getName());
    }

    @Override
    public boolean instrument(CtMethod method) throws CannotCompileException, NotFoundException {
        return false;
    }

    private void doSocketInstrumetation(ClassPool cp) {
        try {
            CtClass clazz = cp.getCtClass("java.net.Socket");
            for (CtMethod m : clazz.getMethods()) {
                CtClass[] exceptions;
                if (!m.getName().equals("connect")) continue;
                StringBuffer buf = new StringBuffer(1000);
                buf.append("{ ");
                buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
                buf.append("  logger.enteringSocketConnect(); ");
                buf.append("} ");
                m.insertAfter(buf.toString(), true);
                for (CtClass e : exceptions = m.getExceptionTypes()) {
                    buf = new StringBuffer(500);
                    buf.append("{ ");
                    buf.append("   org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
                    buf.append("   logger.logErrorSocketConnect(); ");
                    buf.append("   throw $e; ");
                    buf.append("} ");
                    m.addCatch(buf.toString(), e);
                }
                buf = new StringBuffer(1000);
                buf.append("{ ");
                buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
                buf.append("  logger.exitingSocketConnect( $1.toString() ); ");
                buf.append("} ");
                m.insertAfter(buf.toString(), true);
            }
        }
        catch (Exception e) {
            log.severe("failed to instrument java.net.Socket : " + e.getMessage(), new Object[0]);
        }
    }
}

