/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jdk;

import java.util.Arrays;
import java.util.List;
import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtClass;
import org.nudge.javassist.CtField;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.Modifier;
import org.nudge.javassist.NotFoundException;
import org.nudge.javassist.bytecode.DuplicateMemberException;
import org.nudge.probe.Configuration;
import org.nudge.probe.log.Logger;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.ClassDef;

public class ThreadWeaver
extends AbstractWeaver {
    protected static final String THREAD = "java/lang/Thread";
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private static final List<String> excludedPackages = Arrays.asList("org/jboss/threads", "org/jboss/msc");

    @Override
    public boolean matches(ClassDef clazz, ClassLoader cl) {
        for (String s : excludedPackages) {
            if (!clazz.getName().startsWith(s)) continue;
            return false;
        }
        return THREAD.equals(clazz.getName()) || THREAD.equals(clazz.getSuperName());
    }

    @Override
    public boolean beforeInstrument(CtClass clazz) throws CannotCompileException, NotFoundException {
        try {
            clazz.addField(CtField.make("private boolean nudgeInstrumentationActivated = true;", clazz));
            return true;
        }
        catch (DuplicateMemberException dme) {
            log.finer("Duplicate field nudgeInstrumentationActivated in " + clazz.getName());
            return false;
        }
    }

    @Override
    public boolean instrument(CtMethod method) throws CannotCompileException, NotFoundException {
        String name = method.getName();
        int modifiers = method.getModifiers();
        if (name.equals("run") && Modifier.isPublic(modifiers)) {
            this.instrumentRun(method);
            return true;
        }
        return false;
    }

    protected void instrumentRun(CtMethod method) throws CannotCompileException, NotFoundException {
        String signature = method.getLongName();
        StringBuffer buf = new StringBuffer();
        buf.append("{ ");
        buf.append("  if( nudgeInstrumentationActivated ) { ");
        buf.append("    try { ");
        buf.append("      org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("      nudgeInstrumentationActivated = logger.entering(org.nudge.probe.EventType.Runnable,\"" + signature + "\"); ");
        buf.append("    } catch(java.lang.NoClassDefFoundError ncde) { ");
        buf.append("      nudgeInstrumentationActivated = false;");
        buf.append("    } ");
        buf.append("  } ");
        buf.append("} ");
        method.insertBefore(buf.toString());
        this.addCatch(method);
        buf = new StringBuffer(1000);
        buf.append("{ ");
        buf.append("\tif( nudgeInstrumentationActivated ) { ");
        buf.append("\t\ttry { ");
        buf.append("\t\t\torg.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("\t\t\tlogger.exiting( org.nudge.probe.EventType.Runnable, \"" + signature + "\" ); ");
        buf.append("\t\t} catch(java.lang.NoClassDefFoundError ncde) { ");
        buf.append("\t\t} ");
        buf.append("\t} ");
        buf.append("} ");
        method.insertAfter(buf.toString(), true);
    }
}

