/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.nudge.probe.events.BaseEventHandler;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.ProtocolFacade;

public class JmsCommonHandler
extends BaseEventHandler {
    @Override
    protected final void exitAsOutput(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        long time = ip.getTotalTime();
        long error = context.hasThrownException() ? 1L : 0L;
        String type = null;
        String name = null;
        boolean temp = false;
        String action = context.getMethodName();
        StringBuilder code = new StringBuilder();
        try {
            Destination dest = this.getDestination(context);
            if (dest instanceof Topic) {
                type = "topic";
                name = ((Topic)dest).getTopicName();
                temp = dest instanceof TemporaryTopic;
            } else if (dest instanceof Queue) {
                type = "queue";
                name = ((Queue)dest).getQueueName();
                temp = dest instanceof TemporaryQueue;
            }
            code.append(action);
            if (null != type) {
                code.append(" ").append(type);
            }
            if (temp) {
                code.append(" Temp.");
            } else if (name != null) {
                code.append(" ").append(name);
            } else if (null != dest) {
                code.append(" ").append(dest.toString());
            }
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        ProtocolFacade.LayerBuilder builder = context.getProtocol().createOrUpdateLayerItem(ip.getStartTime(), "JMS", code.toString(), ExtendedCode.extCode("jms.destination", name), ExtendedCode.extCode("jms.action", action), ExtendedCode.extCode("jms.type", type), ExtendedCode.extCode("jms.temp", temp ? "true" : null)).addCall(context);
    }

    private Destination getDestination(EventContext context) {
        Object returnValue;
        Destination msgDestination = null;
        for (Object param : context.getMethodParams()) {
            if (param instanceof Destination) {
                return (Destination)param;
            }
            if (!(param instanceof Message)) continue;
            try {
                msgDestination = ((Message)param).getJMSDestination();
            }
            catch (JMSException jMSException) {}
        }
        if (null == msgDestination && (returnValue = context.getReturnValue(Object.class)) instanceof Message) {
            try {
                msgDestination = ((Message)returnValue).getJMSDestination();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return msgDestination;
    }
}

