/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.weave.jms.JmsCommonHandler;

public class JmsReceiveHandler
extends JmsCommonHandler {
    private static final String ON_MESSAGE_SIGNATURE = ".onMessage(javax.jms.Message)";

    @Override
    public void onEntering(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        if (context.getMethodFullName().endsWith(ON_MESSAGE_SIGNATURE)) {
            Message msg = context.getMethodParam(0, Message.class);
            try {
                ip.setUpstreamToken(msg.getStringProperty("NUDGE_TOKEN"));
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            return;
        }
        if (ip.isDefineTx()) {
            ip.makeNotDefineTx();
            return;
        }
        if (ip.isInTx()) {
            ip.makeDefineOutput();
        }
    }
}

