/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jms;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public class JmsReceiveWeaver
extends AbstractAsmWeaver {
    private final Set<String> interfaces = new HashSet<String>(Arrays.asList("javax/jms/JMSConsumer", "javax/jms/MessageConsumer", "javax/jms/MessageListener"));
    private final Set<String> methods = new HashSet<String>(Arrays.asList("receive", "receiveBody", "receiveNoWait", "receiveBodyNoWait", "onMessage"));

    public JmsReceiveWeaver() {
        super("JMS", "org.nudge.probe.weave.jms.JmsReceiveHandler");
    }

    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        for (String interfaceName : def.getAllInterfaces()) {
            if (!this.interfaces.contains(interfaceName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        return method.isPublicInstanceMethod() && this.methods.contains(method.getName());
    }
}

