/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jms;

import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.weave.jms.JmsCommonHandler;

public class JmsSendHandler
extends JmsCommonHandler {
    private int correlationId = -1;

    @Override
    public void onEntering(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        if (ip.isBeyondOutput()) {
            return;
        }
        if (ip.isDefineTx()) {
            ip.makeNotDefineTx();
            return;
        }
        ip.makeDefineOutput(true);
        Message msg = context.getFirstParamOfType(Message.class);
        try {
            msg.setStringProperty("NUDGE_TOKEN", ip.getDownstreamToken());
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    private Message getSendMessage(EventContext context) {
        List<Object> params = context.getMethodParams();
        int msgIndex = 0;
        if (params.get(0) instanceof Destination) {
            msgIndex = 1;
        }
        return context.getMethodParam(msgIndex, Message.class);
    }
}

