/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jms;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public class JmsSendWeaver
extends AbstractAsmWeaver {
    private final Set<String> interfaces = new HashSet<String>(Arrays.asList("javax/jms/JMSProducer", "javax/jms/MessageProducer"));
    private final Set<String> methods = new HashSet<String>(Arrays.asList("send", "publish"));

    public JmsSendWeaver() {
        super("JMS", "org.nudge.probe.weave.jms.JmsSendHandler");
    }

    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        for (String interfaceName : def.getAllInterfaces()) {
            if (!this.interfaces.contains(interfaceName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        return method.isPublic() && this.methods.contains(method.getName());
    }
}

