/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jmx;

import javax.management.MBeanServer;
import org.nudge.probe.Configuration;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.EventHandler;
import org.nudge.probe.log.Logger;
import org.nudge.probe.sampler.JmxBeansSampler;

public class MBeanServerHandler
implements EventHandler {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);

    @Override
    public void onEntering(EventContext context) {
        context.getInstrumentationPoint().makeNotDefineTx();
    }

    @Override
    public void onExiting(EventContext context) {
        MBeanServer mbs = context.getReturnValue(MBeanServer.class);
        JmxBeansSampler.addAlternativeMBeanServer(mbs);
        log.fine("MBeanServerHandler : alternative MBeanServer : %s", mbs.toString());
    }
}

