/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jmx;

import org.nudge.probe.Configuration;
import org.nudge.probe.log.Logger;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public class MBeanServerWeaver
extends AbstractAsmWeaver {
    private static final String MBEANSERVER = "javax/management/MBeanServer";
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);

    public MBeanServerWeaver() {
        super("MBeanServer", "org.nudge.probe.weave.jmx.MBeanServerHandler");
        try {
            Class.forName("org.nudge.probe.weave.jmx.MBeanServerHandler");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean matches(ClassDef clazz, ClassLoader cl) {
        if (clazz.getName().contains("remote")) {
            log.fine("ignoring mbeanserver %s", clazz.getName());
            return false;
        }
        for (String name : clazz.getAllInterfaces()) {
            if (!MBEANSERVER.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        return method.isConstructor();
    }
}

