/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.messaging;

import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtClass;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.ServerMetadata;

public class RabbitMQChannelWeaver
extends AbstractWeaver {
    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        for (String intrfName : def.getAllInterfaces()) {
            if (!"com/rabbitmq/client/Channel".equals(intrfName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean beforeInstrument(CtClass clazz) throws NotFoundException, CannotCompileException {
        this.buildServerMetadata(clazz);
        return true;
    }

    @Override
    public boolean instrument(CtMethod method) throws CannotCompileException, NotFoundException {
        String name = method.getName();
        if (name.equals("basicPublish")) {
            this.basicPublish(method);
            return true;
        }
        return false;
    }

    private void basicPublish(CtMethod method) throws CannotCompileException, NotFoundException {
        StringBuffer buf = new StringBuffer();
        buf.append("{ ");
        buf.append("\torg.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("\tlogger.enteringJMS(); ");
        buf.append("} ");
        method.insertBefore(buf.toString());
        buf = new StringBuffer(1000);
        buf.append("{ ");
        buf.append("   org.nudge.probe.NudgeLogger nudge = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("   nudge.logJMSError(); ");
        buf.append("   throw $e; ");
        buf.append("} ");
        buf = new StringBuffer();
        buf.append("{ ");
        buf.append("\torg.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("\tif (this instanceof " + ServerMetadata.class.getName() + ") {");
        buf.append("\t\tlogger.exitingJMS(org.nudge.probe.EventType.JMS_QUEUE_SEND, \"\", routingKey);");
        buf.append("\t} else { ");
        buf.append("\t\tlogger.exitingJMS(org.nudge.probe.EventType.JMS_QUEUE_SEND, \"\", routingKey);");
        buf.append("\t}");
        buf.append("}");
        method.insertAfter(buf.toString(), true);
    }
}

