/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.messaging;

import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.ServerMetadata;

public class RabbitMQConnection
extends AbstractWeaver {
    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        for (String intrfName : def.getAllInterfaces()) {
            if (!"com/rabbitmq/client/Connection".equals(intrfName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean instrument(CtMethod method) throws CannotCompileException, NotFoundException {
        String name = method.getName();
        if (name.equals("createChannel")) {
            this.createChannel(method);
            return true;
        }
        return false;
    }

    private void createChannel(CtMethod method) throws CannotCompileException, NotFoundException {
        StringBuffer buf = new StringBuffer();
        String className = ServerMetadata.class.getName();
        buf.append("{ ");
        buf.append("\tif ($_ instanceof " + className + ") {");
        buf.append("\ttry { ");
        buf.append("\t\t" + className + " sm = (" + className + ")$_;");
        buf.append("\t\tjava.net.InetAddress add = getAddress();");
        buf.append("\t\tif(add!=null) {");
        buf.append("\t\t\tsm.setNudgeHostName(add.getCanonicalHostName());");
        buf.append("\t\t\tsm.setNudgeHostAddress(add.getHostAddress());");
        buf.append("\t\t} ");
        buf.append("\t\tsm.setNudgePort(getPort());");
        buf.append("\t\tsm.setNudgeProductName(\"RabbitMQ\"); ");
        buf.append("\t\tjava.util.Map props = getServerProperties();");
        buf.append("\t\tif(props!=null) { ");
        buf.append("\t\t\tsm.setNudgeProductVersion((String)props.get(\"version\")); ");
        buf.append("\t\t} ");
        buf.append("\t\tprops = getClientProperties(); ");
        buf.append("\t\tif(props!=null) {");
        buf.append("\t\t\tsm.setNudgeDriverVersion((String)props.get(\"version\")); ");
        buf.append("\t\t} ");
        buf.append("\t} catch(java.lang.Exception e) { ");
        buf.append("\t} ");
        buf.append("\t} ");
        buf.append("} ");
        method.insertAfter(buf.toString(), true);
    }
}

