/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.mongodb;

import com.mongodb.ClientSessionOptions;
import com.mongodb.client.ClientSession;
import java.util.List;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.OutputOnlyHandler;
import org.nudge.probe.log.Logger;

public class MongoClientHandler
extends OutputOnlyHandler {
    private static final Logger log = Logger.getLogger(MongoClientHandler.class.getName());
    private static final String GET_DATABASE_METHOD = "getDatabase";
    private static final String LIST_DATABASE_NAMES_METHOD = "listDatabaseNames";
    private static final String LIST_DATABASES_METHOD = "listDatabases";
    private static final String START_SESSION_METHOD = "startSession";
    private static final String WATCH_METHOD = "watch";
    private final String threeDots = "...";
    private final String comma = " , ";
    private final String clientSessionClass = ClientSession.class.getSimpleName();

    @Override
    protected void exitAsOutput(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        long time = ip.getTotalTime();
        long error = context.hasThrownException() ? 1L : 0L;
        String db = context.getFirstParamOfType(String.class);
        String code = String.format("%s | %s(%s)", "MongoClient", context.getMethodName(), this.getParameter(context));
        context.getProtocol().createOrUpdateLayerItem(ip.getStartTime(), "MongoDB", code, ExtendedCode.extCode("mongodb.db", db), ExtendedCode.extCode("MongoDB", db)).addCall(context);
    }

    public String getParameter(EventContext context) {
        List<Object> objectList = context.getMethodParams();
        String clientSessionClass = ClientSession.class.getSimpleName();
        String parameter = GET_DATABASE_METHOD.equals(context.getMethodName()) ? this.getDatabaseParam(objectList) : (LIST_DATABASE_NAMES_METHOD.equals(context.getMethodName()) && !objectList.isEmpty() ? clientSessionClass : (LIST_DATABASES_METHOD.equals(context.getMethodName()) ? this.getListDatabasesParam(objectList) : (START_SESSION_METHOD.equals(context.getMethodName()) && !objectList.isEmpty() ? ((ClientSessionOptions)objectList.get(0)).toString() : (WATCH_METHOD.equals(context.getMethodName()) ? this.getWatchParam(objectList) : (!objectList.isEmpty() ? "..." : "")))));
        return parameter;
    }

    public String getDatabaseParam(List<Object> objectList) {
        return !objectList.isEmpty() ? objectList.get(0).toString() : "";
    }

    public String getListDatabasesParam(List<Object> objectList) {
        String parameter = "";
        String resultClass = "resultClass";
        switch (objectList.size()) {
            case 0: {
                break;
            }
            case 1: {
                parameter = objectList.get(0) instanceof ClientSession ? this.clientSessionClass : resultClass;
                break;
            }
            case 2: {
                parameter = this.clientSessionClass + " , " + resultClass;
                break;
            }
            default: {
                parameter = "...";
            }
        }
        return parameter;
    }

    public String getWatchParam(List<Object> objectList) {
        String parameter = "";
        String resultClass = "resultClass";
        String pipeline = "pipeline";
        switch (objectList.size()) {
            case 0: {
                break;
            }
            case 1: {
                if (objectList.get(0) instanceof ClientSession) {
                    parameter = this.clientSessionClass;
                    break;
                }
                parameter = objectList.get(0) instanceof List ? pipeline : resultClass;
                break;
            }
            case 2: {
                if (objectList.get(0) instanceof ClientSession) {
                    parameter = objectList.get(1) instanceof List ? this.clientSessionClass + " , " + pipeline : this.clientSessionClass + " , " + resultClass;
                    break;
                }
                parameter = objectList.get(0) instanceof List ? pipeline + " , " + resultClass : resultClass + " , " + pipeline;
                break;
            }
            case 3: {
                parameter = this.clientSessionClass + " , " + pipeline + " , " + resultClass;
                break;
            }
            default: {
                parameter = "...";
            }
        }
        return parameter;
    }
}

