/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import java.util.List;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.OutputOnlyHandler;

public class MongoClientsHandler
extends OutputOnlyHandler {
    @Override
    protected void exitAsOutput(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        long time = ip.getTotalTime();
        long error = context.hasThrownException() ? 1L : 0L;
        String dbUrl = context.getFirstParamOfType(String.class);
        String code = String.format("%s | %s(%s)", "MongoClients", context.getMethodName(), MongoClientsHandler.getParameter(context.getMethodParams()));
        context.getProtocol().createOrUpdateLayerItem(ip.getStartTime(), "MongoDB", code, ExtendedCode.extCode("mongodb.db", dbUrl != null ? dbUrl : "NoURL"), ExtendedCode.extCode("mongodb.db", dbUrl != null ? dbUrl : "NoCollection")).addCall(context);
    }

    public static String getParameter(List<Object> objectList) {
        String parameter = "";
        String threeDots = "...";
        String comma = " , ";
        switch (objectList.size()) {
            case 0: {
                break;
            }
            case 1: {
                parameter = objectList.get(0).toString();
                break;
            }
            case 2: {
                List mongoDriverNames = ((MongoDriverInformation)objectList.get(1)).getDriverNames();
                String mongoDriverName = !mongoDriverNames.isEmpty() ? (String)mongoDriverNames.get(0) : MongoDriverInformation.class.getSimpleName();
                parameter = objectList.get(0) instanceof ConnectionString ? objectList.get(0).toString() + comma + mongoDriverName : MongoClientSettings.class.getSimpleName() + comma + mongoDriverName;
                break;
            }
            default: {
                parameter = threeDots;
            }
        }
        return parameter;
    }
}

