/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.mongodb;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.UpdateOptions;
import java.util.List;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.OutputOnlyHandler;

public class MongoCollectionHandler
extends OutputOnlyHandler {
    private static final String AGGREGATE_METHOD = "aggregate";
    private static final String BULK_WRITE_METHOD = "bulkWrite";
    private static final String COUNT_METHOD = "countDocuments";
    private static final String CREATE_INDEX_METHOD = "createIndex";
    private static final String CREATE_INDEXES_METHOD = "createIndexes";
    private static final String DELETE_MANY_METHOD = "deleteMany";
    private static final String DELETE_ONE_METHOD = "deleteOne";
    private static final String DISTINCT_METHOD = "distinct";
    private static final String DROP_METHOD = "drop";
    private static final String DROP_INDEX_METHOD = "dropIndex";
    private static final String DROP_INDEXES_METHOD = "dropIndexes";
    private static final String FIND_METHOD = "find";
    private static final String FIND_ONE_AND_DELETE_METHOD = "findOneAndDelete";
    private static final String FIND_ONE_AND_REPLACE_METHOD = "findOneAndReplace";
    private static final String FIND_ONE_AND_UPDATE_METHOD = "findOneAndUpdate";
    private static final String INSERT_MANY_METHOD = "insertMany";
    private static final String INSERT_ONE_METHOD = "insertOne";
    private static final String LIST_INDEXES_METHOD = "listIndexes";
    private static final String MAP_REDUCE_METHOD = "mapReduce";
    private static final String RENAME_COLLECTION_METHOD = "renameCollection";
    private static final String REPLACE_ONE_METHOD = "replaceOne";
    private static final String UPDATE_MANY_METHOD = "updateMany";
    private static final String UPDATE_ONE_METHOD = "updateOne";
    private static final String WATCH_METHOD = "watch";
    private static final String WITH_CODEC_REGISTRY_METHOD = "withCodecRegistry";
    private static final String WITH_DOCUMENT_METHOD = "withDocumentClass";
    private static final String WITH_READ_CONCERN_METHOD = "withReadConcern";
    private static final String WITH_READ_PREFERENCE_METHOD = "withReadPreference";
    private static final String WITH_WRITE_CONCERN_METHOD = "withWriteConcern";
    private final String threeDots = "...";
    private final String comma = " , ";
    private final String clientSessionClass = ClientSession.class.getSimpleName();
    private final String bsonClass = Bson.class.getSimpleName();

    @Override
    protected void exitAsOutput(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        MongoCollection collection = context.getMethodTarget(MongoCollection.class);
        long time = ip.getTotalTime();
        long error = context.hasThrownException() ? 1L : 0L;
        String db = collection.getNamespace().getDatabaseName();
        String code = String.format("%s | %s.%s(%s)", collection.getNamespace().getDatabaseName(), collection.getNamespace(), context.getMethodName(), this.getParameter(context));
        context.getProtocol().createOrUpdateLayerItem(ip.getStartTime(), "MongoDB", code, ExtendedCode.extCode("mongodb.db", db), ExtendedCode.extCode("mongodb.collection", collection.getNamespace().toString())).addCall(context);
    }

    public String getParameter(EventContext context) {
        List<Object> objectList = context.getMethodParams();
        int listParamSize = objectList.size();
        String methodName = context.getMethodName();
        String parameter = AGGREGATE_METHOD.equals(methodName) ? this.getParamForAggregateMethod(objectList, listParamSize) : (BULK_WRITE_METHOD.equals(methodName) ? this.getParamForBulkWriteMethod(objectList, listParamSize) : (COUNT_METHOD.equals(methodName) ? this.getParamForCountMethod(objectList, listParamSize) : (CREATE_INDEX_METHOD.equals(methodName) ? this.getParamForCreateIndexMethod(objectList, listParamSize) : (CREATE_INDEXES_METHOD.equals(methodName) ? this.getParamForCreateIndexesMethod(objectList, listParamSize) : (DELETE_MANY_METHOD.equals(methodName) || DELETE_ONE_METHOD.equals(methodName) ? this.getParamForDeleteMethod(objectList, listParamSize) : (DISTINCT_METHOD.equals(methodName) ? this.getParamForDistinctMethod(objectList, listParamSize) : (DROP_METHOD.equals(methodName) ? this.getParamForDropMethod(objectList, listParamSize) : (DROP_INDEX_METHOD.equals(methodName) ? this.getParamForDropIndexMethod(objectList, listParamSize) : (DROP_INDEXES_METHOD.equals(methodName) ? this.getParamForDropIndexesMethod(objectList, listParamSize) : (FIND_METHOD.equals(methodName) ? this.getParamForFindMethod(objectList, listParamSize) : (FIND_ONE_AND_DELETE_METHOD.equals(methodName) ? this.getParamForFindOneAndDeleteMethod(objectList, listParamSize) : (FIND_ONE_AND_REPLACE_METHOD.equals(methodName) ? this.getParamForFindOneAndReplaceMethod(objectList, listParamSize) : (FIND_ONE_AND_UPDATE_METHOD.equals(methodName) ? this.getParamForFindOneAndUpdateMethod(objectList, listParamSize) : (INSERT_MANY_METHOD.equals(methodName) || INSERT_ONE_METHOD.equals(methodName) ? this.getParamForInsertMethod(objectList, listParamSize, methodName) : (LIST_INDEXES_METHOD.equals(methodName) ? this.getParamForListIndexesMethod(objectList, listParamSize) : (MAP_REDUCE_METHOD.equals(methodName) ? this.getParamForMapReduceMethod(objectList, listParamSize) : (RENAME_COLLECTION_METHOD.equals(methodName) ? this.getParamForRenameCollectionMethod(objectList, listParamSize) : (REPLACE_ONE_METHOD.equals(methodName) ? this.getParamForReplaceOneMethod(objectList, listParamSize) : (UPDATE_MANY_METHOD.equals(methodName) || UPDATE_ONE_METHOD.equals(methodName) ? this.getParamForUpdateMethod(objectList, listParamSize) : (WATCH_METHOD.equals(methodName) ? this.getParamForWatchMethod(objectList, listParamSize) : (WITH_READ_PREFERENCE_METHOD.equals(methodName) ? (objectList.isEmpty() ? "" : ((ReadPreference)objectList.get(0)).getName()) : (WITH_WRITE_CONCERN_METHOD.equals(methodName) ? (objectList.isEmpty() ? "" : ((WriteConcern)objectList.get(0)).getWString()) : (WITH_CODEC_REGISTRY_METHOD.equals(methodName) ? CodecRegistry.class.getSimpleName() : (WITH_DOCUMENT_METHOD.equals(methodName) ? "NewTDocument" : (WITH_READ_CONCERN_METHOD.equals(methodName) ? (objectList.isEmpty() ? "" : ((ReadConcern)objectList.get(0)).getLevel().toString()) : (listParamSize >= 1 ? "..." : ""))))))))))))))))))))))))));
        return parameter;
    }

    public String getParamForWatchMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        if (!objectList.isEmpty()) {
            if (objectList.get(0) instanceof ClientSession) {
                switch (listParamSize) {
                    case 1: {
                        parameter = this.clientSessionClass;
                        break;
                    }
                    case 2: {
                        parameter = objectList.get(1) instanceof List ? this.clientSessionClass + " , " + "pipeline" : this.clientSessionClass + " , " + "resultClass";
                        break;
                    }
                    case 3: {
                        parameter = this.clientSessionClass + " , " + "pipeline" + " , " + "resultClass";
                        break;
                    }
                    default: {
                        parameter = "...";
                        break;
                    }
                }
            } else {
                switch (listParamSize) {
                    case 1: {
                        parameter = objectList.get(0) instanceof List ? "pipeline" : "resultClass";
                        break;
                    }
                    case 2: {
                        parameter = "pipeline , resultClass";
                    }
                }
            }
        }
        return parameter;
    }

    public String getParamForUpdateMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String updateOptionClass = UpdateOptions.class.getSimpleName();
        String str = this.bsonClass + " , " + this.bsonClass;
        String str1 = this.clientSessionClass + " , " + str;
        if (listParamSize != 0) {
            parameter = objectList.get(0) instanceof Bson ? (listParamSize == 2 ? str : str + updateOptionClass) : (listParamSize == 3 ? str1 : str1 + updateOptionClass);
        }
        return parameter;
    }

    public String getParamForReplaceOneMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String updateOptionClass = UpdateOptions.class.getSimpleName();
        String str = this.bsonClass + " , " + "document";
        String str1 = this.clientSessionClass + " , " + str;
        if (listParamSize != 0) {
            parameter = objectList.get(0) instanceof ClientSession ? (listParamSize == 3 ? str1 : str1 + " , " + updateOptionClass) : (listParamSize == 2 ? str : str + " , " + updateOptionClass);
        }
        return parameter;
    }

    public String getParamForRenameCollectionMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String renameOptionClass = RenameCollectionOptions.class.getSimpleName();
        String str = this.clientSessionClass + " , ";
        if (listParamSize != 0) {
            parameter = objectList.get(0) instanceof ClientSession ? (listParamSize == 2 ? str + ((MongoNamespace)objectList.get(1)).getCollectionName() : str + ((MongoNamespace)objectList.get(1)).getCollectionName() + renameOptionClass) : (listParamSize == 1 ? ((MongoNamespace)objectList.get(0)).getCollectionName() : ((MongoNamespace)objectList.get(0)).getCollectionName() + " , " + renameOptionClass);
        }
        return parameter;
    }

    public String getParamForMapReduceMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String resulSetClass = "resultSetClass";
        String str2 = "mapFonction , reduceFunction";
        String str = this.clientSessionClass + " , " + str2;
        if (listParamSize != 0) {
            parameter = objectList.get(0) instanceof ClientSession ? (listParamSize == 3 ? str : str + " , " + resulSetClass) : (listParamSize == 2 ? str2 : str2 + " , " + resulSetClass);
        }
        return parameter;
    }

    public String getParamForListIndexesMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String resulSetClass = "resultSetClass";
        if (!objectList.isEmpty()) {
            parameter = objectList.get(0) instanceof ClientSession ? (listParamSize == 1 ? this.clientSessionClass : this.clientSessionClass + " , " + resulSetClass) : resulSetClass;
        }
        return parameter;
    }

    public String getParamForInsertMethod(List<Object> objectList, int listParamSize, String methodName) {
        String parameter = "";
        String document = methodName.contains("many") ? "documents" : "document";
        String insertOptionClass = methodName.contains("many") ? InsertManyOptions.class.getSimpleName() : InsertOneOptions.class.getSimpleName();
        String str = this.clientSessionClass + " , ";
        String insertManyOptionClass = InsertManyOptions.class.getSimpleName();
        if (!objectList.isEmpty()) {
            parameter = objectList.get(0) instanceof ClientSession ? (listParamSize == 2 ? str + document : str + document + " , " + insertOptionClass) : (listParamSize == 1 ? document : document + " , " + insertOptionClass);
        }
        return parameter;
    }

    public String getParamForFindOneAndUpdateMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String str = this.bsonClass + " , " + this.bsonClass;
        String str2 = this.clientSessionClass + " , " + str;
        if (listParamSize != 0) {
            parameter = objectList.get(0) instanceof Bson ? (listParamSize == 2 ? str : str + " , " + FindOneAndUpdateOptions.class.getSimpleName()) : (listParamSize == 3 ? str2 : str2 + " , " + FindOneAndUpdateOptions.class.getSimpleName());
        }
        return parameter;
    }

    public String getParamForFindOneAndReplaceMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String str = this.bsonClass + " , " + MongoCollection.class.getSimpleName();
        String str2 = this.clientSessionClass + " , " + str;
        if (listParamSize != 0) {
            parameter = objectList.get(0) instanceof Bson ? (listParamSize == 2 ? str : str + " , " + FindOneAndReplaceOptions.class.getSimpleName()) : (listParamSize == 3 ? str2 : str2 + " , " + FindOneAndReplaceOptions.class.getSimpleName());
        }
        return parameter;
    }

    public String getParamForFindOneAndDeleteMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String str = this.clientSessionClass + " , " + this.bsonClass;
        if (!objectList.isEmpty()) {
            parameter = objectList.get(0) instanceof Bson ? (listParamSize == 1 ? this.bsonClass : this.bsonClass + " , " + FindOneAndDeleteOptions.class.getSimpleName()) : (listParamSize == 2 ? str : str + " , " + FindOneAndDeleteOptions.class.getSimpleName());
        }
        return parameter;
    }

    public String getParamForFindMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String resulSetClass = "ResultSetClass";
        if (!objectList.isEmpty()) {
            if (objectList.get(0) instanceof ClientSession) {
                switch (listParamSize) {
                    case 1: {
                        parameter = this.clientSessionClass;
                        break;
                    }
                    case 2: {
                        parameter = objectList.get(1) instanceof Bson ? this.clientSessionClass + " , " + this.bsonClass : this.clientSessionClass + " , " + resulSetClass;
                        break;
                    }
                    case 3: {
                        parameter = this.clientSessionClass + " , " + this.bsonClass + " , " + resulSetClass;
                        break;
                    }
                    default: {
                        parameter = "...";
                        break;
                    }
                }
            } else {
                parameter = objectList.get(0) instanceof Bson ? (listParamSize == 1 ? this.bsonClass : this.bsonClass + " , " + resulSetClass) : (listParamSize == 0 ? parameter : resulSetClass);
            }
        }
        return parameter;
    }

    public String getParamForDropIndexesMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String dropIndexOptionsClass = DropIndexOptions.class.getSimpleName();
        switch (listParamSize) {
            case 0: {
                break;
            }
            case 1: {
                parameter = objectList.get(0) instanceof ClientSession ? this.clientSessionClass : dropIndexOptionsClass;
                break;
            }
            case 2: {
                parameter = this.clientSessionClass + " , " + dropIndexOptionsClass;
                break;
            }
            default: {
                parameter = "...";
            }
        }
        return parameter;
    }

    public String getParamForDropMethod(List<Object> objectList, int listParamSize) {
        return listParamSize == 1 ? this.clientSessionClass : "";
    }

    public String getParamForDropIndexMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String dropIndexOptionsClass = DropIndexOptions.class.getSimpleName();
        if (!objectList.isEmpty()) {
            if (objectList.get(0) instanceof ClientSession) {
                switch (listParamSize) {
                    case 2: {
                        parameter = objectList.get(1) instanceof String ? this.clientSessionClass + " , " + objectList.get(1) : this.clientSessionClass + " , " + this.bsonClass;
                        break;
                    }
                    case 3: {
                        parameter = objectList.get(1) instanceof String ? this.clientSessionClass + " , " + objectList.get(1) + " , " + dropIndexOptionsClass : this.clientSessionClass + " , " + this.bsonClass + " , " + dropIndexOptionsClass;
                        break;
                    }
                    default: {
                        parameter = "...";
                        break;
                    }
                }
            } else {
                parameter = objectList.get(0) instanceof Bson ? (listParamSize == 1 ? this.bsonClass : this.bsonClass + " , " + dropIndexOptionsClass) : (listParamSize == 1 ? (String)objectList.get(0) : objectList.get(0) + " , " + dropIndexOptionsClass);
            }
        }
        return parameter;
    }

    public String getParamForDistinctMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String resultClass = "resultClass";
        if (!objectList.isEmpty()) {
            parameter = objectList.get(0) instanceof ClientSession ? (listParamSize == 3 ? this.clientSessionClass + " , " + objectList.get(1) + " , " + resultClass : this.clientSessionClass + " , " + objectList.get(1) + " , " + this.bsonClass + " , " + resultClass) : (listParamSize == 2 ? objectList.get(0) + " , " + resultClass : objectList.get(0) + " , " + this.bsonClass + " , " + resultClass);
        }
        return parameter;
    }

    public String getParamForDeleteMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String str = this.clientSessionClass + " , " + this.bsonClass;
        String deleteOptionClass = DeleteOptions.class.getSimpleName();
        if (!objectList.isEmpty()) {
            parameter = objectList.get(0) instanceof ClientSession ? (listParamSize == 2 ? str : str + " , " + deleteOptionClass) : (listParamSize == 1 ? this.bsonClass : this.bsonClass + " , " + deleteOptionClass);
        }
        return parameter;
    }

    public String getParamForCreateIndexesMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String str = this.clientSessionClass + " , " + "indexModelList";
        String createOptionsClass = CreateIndexOptions.class.getSimpleName();
        if (!objectList.isEmpty()) {
            parameter = objectList.get(0) instanceof ClientSession ? (listParamSize == 2 ? str : str + " , " + createOptionsClass) : (listParamSize == 1 ? "indexModelList" : "indexModelList , " + createOptionsClass);
        }
        return parameter;
    }

    public String getParamForCreateIndexMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String str = this.clientSessionClass + " , " + this.bsonClass;
        if (!objectList.isEmpty()) {
            parameter = objectList.get(0) instanceof ClientSession ? (listParamSize == 2 ? str : str + " , " + ((IndexOptions)objectList.get(2)).getName()) : (listParamSize == 1 ? this.bsonClass : this.bsonClass + " , " + ((IndexOptions)objectList.get(1)).getName());
        }
        return parameter;
    }

    public String getParamForCountMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String str = this.clientSessionClass + " , " + this.bsonClass;
        String bulkWriteOptionsClass = BulkWriteOptions.class.getSimpleName();
        if (!objectList.isEmpty()) {
            if (objectList.get(0) instanceof ClientSession) {
                switch (listParamSize) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        parameter = this.clientSessionClass;
                        break;
                    }
                    case 2: {
                        parameter = str;
                        break;
                    }
                    case 3: {
                        parameter = str + " , " + CountOptions.class.getSimpleName();
                        break;
                    }
                    default: {
                        parameter = "...";
                        break;
                    }
                }
            } else if (objectList.get(0) instanceof Bson) {
                switch (listParamSize) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        parameter = this.bsonClass;
                        break;
                    }
                    case 2: {
                        parameter = this.bsonClass + " , " + CountOptions.class.getSimpleName();
                        break;
                    }
                    default: {
                        parameter = "...";
                    }
                }
            }
        }
        return parameter;
    }

    public String getParamForAggregateMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String pipeline = "pipeline";
        String resultClass = "resultClass";
        String str = this.clientSessionClass + " , " + pipeline;
        if (!objectList.isEmpty()) {
            parameter = objectList.get(0) instanceof ClientSession ? (objectList.size() == 2 ? str : str + " , " + resultClass) : (objectList.size() == 1 ? pipeline : pipeline + " , " + resultClass);
        }
        return parameter;
    }

    public String getParamForBulkWriteMethod(List<Object> objectList, int listParamSize) {
        String parameter = "";
        String str = this.clientSessionClass + " , " + "request";
        String bulkWriteOptionsClass = BulkWriteOptions.class.getSimpleName();
        if (!objectList.isEmpty()) {
            parameter = objectList.get(0) instanceof ClientSession ? (listParamSize == 2 ? str : str + " , " + bulkWriteOptionsClass) : (listParamSize == 1 ? "request" : "request" + bulkWriteOptionsClass);
        }
        return parameter;
    }
}

