/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.mongodb;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import java.util.List;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.OutputOnlyHandler;
import org.nudge.probe.log.Logger;

public class MongoDatabaseHandler
extends OutputOnlyHandler {
    private static final Logger log = Logger.getLogger(MongoDatabaseHandler.class.getName());
    private static final String AGGREGATE_METHOD = "aggregate";
    private static final String CREATE_COLLECTION_METHOD = "createCollection";
    private static final String CREATE_VIEW_METHOD = "createView";
    private static final String DROP_METHOD = "drop";
    private static final String GET_COLLECTION_METHOD = "getCollection";
    private static final String LIST_COLLECTION_NAMES_METHOD = "listCollectionNames";
    private static final String LIST_COLLECTIONS_METHOD = "listCollections";
    private static final String RUN_COMMAND_METHOD = "runCommand";
    private static final String WATCH_METHOD = "watch";
    private static final String WITH_CODEC_REGISTRY_METHOD = "withCodecRegistry";
    private static final String WITH_READ_CONCERN_METHOD = "withReadConcern";
    private static final String WITH_READ_PREFERENCE_METHOD = "withReadPreference";
    private static final String WITH_WRITE_CONCERN_METHOD = "withWriteConcern";
    private final String threeDots = "...";
    private final String comma = " , ";
    private final String clientSessionClass = ClientSession.class.getSimpleName();
    private final String bsonClass = Bson.class.getSimpleName();

    @Override
    protected void exitAsOutput(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        MongoDatabase database = context.getMethodTarget(MongoDatabase.class);
        long time = ip.getTotalTime();
        long error = context.hasThrownException() ? 1L : 0L;
        String db = database.getName();
        String code = String.format("%s | %s | %s(%s)", "MongoDatabase", db, context.getMethodName(), this.getParameter(context));
        context.getProtocol().createOrUpdateLayerItem(ip.getStartTime(), "MongoDB", code, ExtendedCode.extCode("mongodb.db", db), ExtendedCode.extCode("mongodb.db", db)).addCall(context);
    }

    public String getParameter(EventContext context) {
        List<Object> objectList = context.getMethodParams();
        String methodName = context.getMethodName();
        String parameter = CREATE_COLLECTION_METHOD.equals(methodName) ? this.getCreateCollectionParam(objectList) : (AGGREGATE_METHOD.equals(methodName) ? this.getAggregateParam(objectList) : (CREATE_VIEW_METHOD.equals(methodName) ? this.getCreateViewParam(objectList) : (DROP_METHOD.equals(methodName) && objectList.size() == 1 ? this.clientSessionClass : (GET_COLLECTION_METHOD.equals(methodName) ? this.getGetCollectionParam(objectList) : (LIST_COLLECTION_NAMES_METHOD.equals(methodName) && objectList.size() == 1 ? this.clientSessionClass : (LIST_COLLECTIONS_METHOD.equals(methodName) && objectList.size() >= 1 ? this.getListCollectionsParam(objectList) : (RUN_COMMAND_METHOD.equals(methodName) ? this.getRunCommandParam(objectList) : (WATCH_METHOD.equals(methodName) ? this.getParamForWatchMethod(objectList) : (WITH_CODEC_REGISTRY_METHOD.equals(methodName) ? CodecRegistry.class.getSimpleName() : (WITH_READ_CONCERN_METHOD.equals(methodName) ? ReadConcern.class.getSimpleName() : (WITH_READ_PREFERENCE_METHOD.equals(methodName) ? ReadPreference.class.getSimpleName() : (WITH_WRITE_CONCERN_METHOD.equals(methodName) ? WriteConcern.class.getSimpleName() : (objectList.size() >= 1 ? "..." : "")))))))))))));
        return parameter;
    }

    public String getAggregateParam(List<Object> objectList) {
        String parameter = "";
        String pipeline = "pipeline";
        String resultClass = "resultClass";
        String str = this.clientSessionClass + " , " + pipeline;
        if (!objectList.isEmpty()) {
            parameter = objectList.get(0) instanceof ClientSession ? (objectList.size() == 2 ? str : str + " , " + resultClass) : (objectList.size() == 1 ? pipeline : pipeline + " , " + resultClass);
        }
        return parameter;
    }

    public String getParamForWatchMethod(List<Object> objectList) {
        String parameter = "";
        if (!objectList.isEmpty()) {
            if (objectList.get(0) instanceof ClientSession) {
                switch (objectList.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        parameter = this.clientSessionClass;
                        break;
                    }
                    case 2: {
                        parameter = objectList.get(1) instanceof List ? this.clientSessionClass + " , " + "pipeline" : this.clientSessionClass + " , " + "resultClass";
                        break;
                    }
                    case 3: {
                        parameter = this.clientSessionClass + " , " + "pipeline" + " , " + "resultClass";
                        break;
                    }
                    default: {
                        parameter = "...";
                        break;
                    }
                }
            } else {
                switch (objectList.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        parameter = objectList.get(0) instanceof List ? "pipeline" : "resultClass";
                        break;
                    }
                    case 2: {
                        parameter = "pipeline , resultClass";
                    }
                }
            }
        }
        return parameter;
    }

    public String getRunCommandParam(List<Object> objectList) {
        String parameter = "";
        String str = this.clientSessionClass + " , " + this.bsonClass;
        String resultClass = "resultClass";
        if (!objectList.isEmpty()) {
            if (objectList.get(0) instanceof ClientSession) {
                switch (objectList.size()) {
                    case 2: {
                        parameter = str;
                        break;
                    }
                    case 3: {
                        parameter = objectList.get(2) instanceof ReadPreference ? str + " , " + ((ReadPreference)objectList.get(2)).getName() : str + " , " + resultClass;
                        break;
                    }
                    case 4: {
                        parameter = str + " , " + ((ReadPreference)objectList.get(2)).getName() + " , " + resultClass;
                        break;
                    }
                    default: {
                        parameter = "...";
                        break;
                    }
                }
            } else {
                switch (objectList.size()) {
                    case 1: {
                        parameter = this.bsonClass;
                        break;
                    }
                    case 2: {
                        parameter = objectList.get(1) instanceof ReadPreference ? this.bsonClass + " , " + ((ReadPreference)objectList.get(1)).getName() : this.bsonClass + " , " + resultClass;
                        break;
                    }
                    case 3: {
                        parameter = this.bsonClass + " , " + ((ReadPreference)objectList.get(1)).getName() + " , " + resultClass;
                        break;
                    }
                    default: {
                        parameter = "...";
                    }
                }
            }
        }
        return parameter;
    }

    public String getListCollectionsParam(List<Object> objectList) {
        String parameter = "";
        String resultClass = "resultClass";
        if (!objectList.isEmpty()) {
            parameter = objectList.get(0) instanceof ClientSession ? (objectList.size() == 2 ? this.clientSessionClass + " , " + resultClass : this.clientSessionClass) : resultClass;
        }
        return parameter;
    }

    public String getGetCollectionParam(List<Object> objectList) {
        String parameter;
        try {
            parameter = objectList.size() == 1 ? objectList.get(0).toString() : objectList.get(0).toString() + " , " + "resulClass";
        }
        catch (Exception exception) {
            parameter = "...";
            log.severe(exception, "cannot get method parameter for getCollection())", new Object[0]);
        }
        return parameter;
    }

    public String getCreateCollectionParam(List<Object> objectList) {
        String parameter = "";
        String createCollectionOptionClass = CreateCollectionOptions.class.getSimpleName();
        String resultClass = "resultClass";
        String str = this.clientSessionClass + " , ";
        if (!objectList.isEmpty()) {
            parameter = objectList.get(0) instanceof ClientSession ? (objectList.size() == 2 ? str + objectList.get(1).toString() + " , " + resultClass : str + objectList.get(1).toString() + " , " + resultClass + " , " + createCollectionOptionClass) : (objectList.size() == 1 ? objectList.get(0).toString() : objectList.get(0).toString() + " , " + createCollectionOptionClass);
        }
        return parameter;
    }

    public String getCreateViewParam(List<Object> objectList) {
        String parameter = "";
        String pipeline = "pipeline";
        if (!objectList.isEmpty()) {
            if (objectList.get(0) instanceof String) {
                switch (objectList.size()) {
                    case 3: {
                        parameter = objectList.get(0).toString() + " , " + objectList.get(1).toString() + " , " + pipeline;
                        break;
                    }
                    case 4: {
                        parameter = objectList.get(0).toString() + " , " + objectList.get(1).toString() + " , " + pipeline + " , " + CreateViewOptions.class.getSimpleName();
                        break;
                    }
                    default: {
                        parameter = "...";
                        break;
                    }
                }
            } else {
                switch (objectList.size()) {
                    case 4: {
                        parameter = this.clientSessionClass + " , " + objectList.get(1) + " , " + objectList.get(2) + " , " + pipeline;
                        break;
                    }
                    case 5: {
                        parameter = this.clientSessionClass + " , " + objectList.get(1) + " , " + objectList.get(2) + " , " + pipeline + " , " + CreateViewOptions.class.getSimpleName();
                        break;
                    }
                    default: {
                        parameter = "...";
                    }
                }
            }
        }
        return parameter;
    }
}

