/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.play;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtClass;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.NotFoundException;
import org.nudge.javassist.bytecode.MethodInfo;
import org.nudge.probe.weave.OLD.AbstractHandler;
import org.nudge.probe.weave.OLD.Weaver;
import org.nudge.probe.weave.play.PlayAnalyzer;

public class PlayControllerHandler
extends AbstractHandler {
    private Weaver weaver;
    private ClassLoader loader;

    public PlayControllerHandler(Weaver weaver, ClassLoader loader) {
        this.weaver = weaver;
        this.loader = loader;
    }

    @Override
    public boolean match(CtClass clazz) {
        return "play.mvc.Controller".equals(clazz.getName());
    }

    @Override
    protected boolean useFilter() {
        return false;
    }

    @Override
    public void instrument(CtClass cc, CtClass filter, LinkedList<String> instrumentedMethods) throws NotFoundException, CannotCompileException {
        this.beforeInstrument(cc);
        for (CtMethod m : cc.getMethods()) {
            MethodInfo methodInfo = m.getMethodInfo();
            if (!Modifier.isPublic(m.getModifiers()) || !Modifier.isStatic(m.getModifiers()) || !methodInfo.isMethod() || Modifier.isNative(m.getModifiers()) || Modifier.isAbstract(m.getModifiers()) || instrumentedMethods.contains(m.getLongName()) || !m.getDeclaringClass().getName().equals(cc.getName())) continue;
            boolean inst = false;
            boolean ok = false;
            CannotCompileException e = null;
            for (int count = 0; !ok && count < 100; ++count) {
                try {
                    this.instrument(m);
                    instrumentedMethods.addFirst(m.getLongName());
                    ok = true;
                    continue;
                }
                catch (CannotCompileException cce) {
                    e = cce;
                    PlayAnalyzer playAnalyzer = new PlayAnalyzer(this.loader);
                    if (!playAnalyzer.isPlay()) {
                        throw e;
                    }
                    log.fine(cc.getName() + " CannotCompileException failure #" + count, new Object[0]);
                    int i = e.getMessage().indexOf("cannot find ");
                    if (i != -1) {
                        String missingClass = e.getMessage().substring(i + 12);
                        try {
                            log.fine("Adding class explicitly using play compiler: " + missingClass, new Object[0]);
                            long t0 = System.currentTimeMillis();
                            cc.getClassPool().makeClass(new ByteArrayInputStream(playAnalyzer.getClassPath(missingClass)));
                            this.weaver.increaseThreshold(System.currentTimeMillis() - t0);
                            continue;
                        }
                        catch (Exception nfe) {
                            nfe.printStackTrace();
                            throw cce;
                        }
                    }
                    throw e;
                }
            }
            if (inst) {
                instrumentedMethods.addFirst(m.getLongName());
            }
            if (ok || e == null) continue;
            throw e;
        }
    }

    private void instrument(CtMethod method) throws CannotCompileException, NotFoundException {
        String signature = method.getLongName();
        StringBuffer buf = new StringBuffer(1000);
        buf.append("{ ");
        buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("  logger.entering(org.nudge.probe.EventType.Play_MvcController,\"" + signature + "\"); ");
        buf.append("  logger.setTransactionUrl( \"" + signature + "\" ); ");
        buf.append("} ");
        method.insertBefore(buf.toString());
        this.addCatch(method);
        buf = new StringBuffer(1000);
        buf.append("{ ");
        buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("  logger.exiting( org.nudge.probe.EventType.Play_MvcController, \"" + signature + "\" ); ");
        buf.append("} ");
        method.insertAfter(buf.toString(), true);
    }
}

