/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.remoting;

import java.util.HashSet;
import java.util.Set;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public class RmiWeaver
extends AbstractAsmWeaver {
    private static final String JAVA_RMI_REMOTE = "java/rmi/Remote";
    private static final String JAX_RPC_STUB = "javax/xml/rpc/Stub";
    private Set<String> rmiMethods = new HashSet<String>();

    public RmiWeaver() {
        super("RMI", "org.nudge.probe.weave.remoting.RmiHandler");
    }

    @Override
    public boolean matches(ClassDef clazz, ClassLoader cl) {
        Set<String> interfaces = clazz.getAllInterfaces();
        if (interfaces.contains(JAX_RPC_STUB)) {
            return false;
        }
        for (String name : interfaces) {
            if (!name.startsWith("java/sql/") && !name.startsWith("javax/sql/")) continue;
            return false;
        }
        for (String name : interfaces) {
            if (!JAVA_RMI_REMOTE.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void beforeInstrument(byte[] classBytes, String className, ClassLoader cl) {
        ClassDef classDef = ClassDef.fromBytecode(classBytes, cl);
        for (String i : classDef.getAllInterfaces()) {
            ClassDef interfaceDef = ClassDef.fromClassLoaderResource(i, cl);
            if (null == interfaceDef || !interfaceDef.getAllInterfaces().contains(JAVA_RMI_REMOTE)) continue;
            for (MethodDef method : interfaceDef.getMethods()) {
                this.rmiMethods.add(method.getCacheKey());
            }
        }
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        return method.isPublicInstanceMethod() && (this.rmiMethods.isEmpty() || this.rmiMethods.contains(method.getCacheKey()));
    }
}

