/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.servlet;

import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.Modifier;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.ClassDef;

public class HttpJspWriterWeaver
extends AbstractWeaver {
    private static final String javascriptStart = "<script type=\\\"text/javascript\\\"> nudgePerf = function(){\\n var u='";
    private static final String javascriptEnd = "';var s='#';var t=window.performance.timing;var d=t.navigationStart;var b=u+s;var a=function(v){v=v-d;v=isNaN(v)||v<=0?-1:v;b+=(s+v);};b+=d;a(t.unloadEventStart);a(t.unloadEventEnd);a(t.redirectStart);a(t.redirectEnd);a(t.fetchStart);a(t.domainLookupStart);a(t.domainLookupEnd);a(t.connectStart);a(t.connectEnd);a(t.secureConnectionStart);a(t.requestStart);a(t.responseStart);a(t.responseEnd);a(t.domLoading);a(t.domInteractive);a(t.domContentLoadedEventStart);a(t.domContentLoadedEventEnd);a(t.domComplete);a(t.loadEventStart);a(new Date().getTime());document.cookie = 'nudge='+b;}; if(window.performance){  if(window.addEventListener){   window.addEventListener('load', nudgePerf); } else { var p = window.onload;  window.onload = function(){ if(p){p();} nudgePerf(); }}}</script>";

    public boolean matches(ClassDef clazz) {
        return "javax/servlet/jsp/JspWriter".equals(clazz.getSuperName()) || "weblogic/servlet/jsp/JspWriterImpl".equals(clazz.getName()) || "javax/faces/context/ResponseWriter".equals(clazz.getName()) || clazz.getAllSuperNames().contains("javax/faces/context/ResponseWriter");
    }

    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        return this.matches(def);
    }

    @Override
    public boolean instrument(CtMethod method) throws CannotCompileException, NotFoundException {
        String name = method.getName();
        if (name.equals("print") || name.equals("println")) {
            if (Modifier.isPublic(method.getModifiers()) && method.getSignature().startsWith("(Ljava/lang/String;")) {
                this.buildPrinter(method);
                return true;
            }
        } else if (name.equals("write") && Modifier.isPublic(method.getModifiers())) {
            if (method.getSignature().startsWith("(Ljava/lang/String;II")) {
                this.buildWriter(method);
                return true;
            }
            if (method.getSignature().startsWith("(Ljava/lang/String;")) {
                this.buildPrinter(method);
                return true;
            }
            if (method.getSignature().equals("([BLjava/lang/String;)V")) {
                this.weblogicJspWriter(method);
                return true;
            }
        } else if (name.equals("endElement") && Modifier.isPublic(method.getModifiers())) {
            StringBuilder buf = new StringBuilder();
            buf.append("{ ");
            buf.append("\tif($1.equalsIgnoreCase(\"body\")){");
            buf.append("\t\twrite(\"").append(HttpJspWriterWeaver.nudgeJavascript()).append("\\n\");");
            buf.append("\t\twrite(\"</\");");
            buf.append("\t\twrite($1);");
            buf.append("\t\twrite(\">\\n\");");
            buf.append("\t\treturn;");
            buf.append("\t}");
            buf.append("} ");
            method.insertBefore(buf.toString());
        }
        return false;
    }

    private static String nudgeJavascript() {
        return String.format("%s\"+ org.nudge.probe.LoggerFactory.getLogger().getRumId()+\"%s", javascriptStart, javascriptEnd);
    }

    private void buildWriter(CtMethod method) throws CannotCompileException, NotFoundException {
        StringBuilder buf = new StringBuilder();
        buf.append("{ ");
        buf.append("\tif( null != $1) {");
        buf.append("\t\tint idx = $1.indexOf(\"</html>\");");
        buf.append("\t\tif( idx < 0){ idx = $1.indexOf(\"</HTML>\");}");
        buf.append("\t\tif (idx != -1 && idx >= $2 && idx < $2 + $3) {");
        buf.append("\t\t\tString javascript = \"").append(HttpJspWriterWeaver.nudgeJavascript()).append("\" ;");
        buf.append("\t\t\t$1 += javascript;");
        buf.append("\t\t\t$3 += javascript.length();");
        buf.append("\t\t}");
        buf.append("\t}");
        buf.append("} ");
        method.insertBefore(buf.toString());
    }

    private void weblogicJspWriter(CtMethod method) throws CannotCompileException, NotFoundException {
        StringBuilder buf = new StringBuilder();
        buf.append("{ ");
        buf.append("\tif( null != $2) {");
        buf.append("\t\tint idx = $2.indexOf(\"</html>\");");
        buf.append("\t\tif( idx < 0){ idx = $2.indexOf(\"</HTML>\");}");
        buf.append("\t\tif (idx != -1) {");
        buf.append("\t\t\t$2 += (\"").append(HttpJspWriterWeaver.nudgeJavascript()).append("\") ;");
        buf.append("\t\t\t$1 = $2.getBytes() ;");
        buf.append("\t\t}");
        buf.append("\t}");
        buf.append("} ");
        method.insertBefore(buf.toString());
    }

    private void buildPrinter(CtMethod method) throws CannotCompileException, NotFoundException {
        StringBuilder buf = new StringBuilder();
        buf.append("{ ");
        buf.append("\tif( null != $1) {");
        buf.append("\t\tint idx = $1.indexOf(\"</html>\");");
        buf.append("\t\tif( idx < 0){ idx = $1.indexOf(\"</HTML>\");}");
        buf.append("\t\tif (idx != -1) {");
        buf.append("\t\t\torg.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("\t\t\t$1 += (\"").append(HttpJspWriterWeaver.nudgeJavascript()).append("\") ;");
        buf.append("\t\t}");
        buf.append("\t}");
        buf.append("} ");
        method.insertBefore(buf.toString());
    }
}

