/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.servlet;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public class HttpServletContextListenerWeaver
extends AbstractAsmWeaver {
    private static final Set<String> METHODS = new HashSet<String>(Arrays.asList("contextInitialized", "contextDestroyed"));
    private static final String SIGNATURE = "(Ljavax/servlet/ServletContextEvent;)V";

    public HttpServletContextListenerWeaver() {
        super("Servlet", "org.nudge.probe.events.BaseEventHandler");
    }

    @Override
    public boolean matches(ClassDef clazz, ClassLoader cl) {
        return clazz.getAllInterfaces().contains("javax/servlet/ServletContextListener");
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        return METHODS.contains(method.getName()) && SIGNATURE.equals(method.getSignature());
    }
}

