/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.servlet;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public class HttpServletWeaver
extends AbstractAsmWeaver {
    private static final Set<String> SERVLET_METHODS = new HashSet<String>(Arrays.asList("service", "_jspService"));
    private static final String SERVLET_METHOD_SIGNATURE = "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V";
    private static final String FILTER_METHOD = "doFilter";
    private static final String FILTER_METHOD_SIGNATURE_PREFIX = "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;";
    private static final String FILTER_INIT_METHOD_SIGNATURE = "(Ljavax/servlet/FilterConfig;)V";
    private static final String JAVAX_HTTP_SERVLET = "javax/servlet/http/HttpServlet";
    private boolean isFilter = false;
    private boolean isServlet = false;

    public HttpServletWeaver() {
        super("Servlet", "org.nudge.probe.weave.servlet.HttpServletHandler");
    }

    @Override
    public boolean matches(ClassDef clazz, ClassLoader cl) {
        Set<String> interfaces = clazz.getAllInterfaces();
        this.isServlet = clazz.getName().equals(JAVAX_HTTP_SERVLET) || clazz.getAllSuperNames().contains(JAVAX_HTTP_SERVLET) || interfaces.contains("javax/servlet/jsp/HttpJspPage");
        this.isFilter = interfaces.contains("javax/servlet/Filter") || interfaces.contains("javax/servlet/FilterChain");
        return this.isServlet || this.isFilter;
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        String methodSignature = method.getSignature();
        String methodName = method.getName();
        boolean instrument = false;
        if (this.isServlet) {
            instrument |= SERVLET_METHODS.contains(methodName) && SERVLET_METHOD_SIGNATURE.equals(methodSignature);
        }
        if (this.isFilter) {
            instrument |= FILTER_METHOD.equals(methodName) && methodSignature.startsWith(FILTER_METHOD_SIGNATURE_PREFIX);
            instrument |= "init".equals(methodName) && methodSignature.equals(FILTER_INIT_METHOD_SIGNATURE);
        }
        return instrument;
    }
}

