/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.servlet;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nudge.probe.Configuration;
import org.nudge.probe.events.BaseEventHandler;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.ProtocolFacade;
import org.nudge.probe.weave.servlet.Servlets;

public class JakartaHttpServletHandler
extends BaseEventHandler {
    private static final List<String> IP_HEADERS = Arrays.asList("X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR");

    @Override
    public void onEntering(EventContext context) {
        HttpServletRequest request;
        int version;
        InstrumentationPoint ip = context.getInstrumentationPoint();
        boolean filterInit = "init".equals(context.getMethodName());
        if (filterInit && ip.isDefineTx()) {
            ip.makeNotDefineTx();
        }
        if ((version = Servlets.getVersion()) <= 0) {
            ServletContext servletContext = null;
            Object targetObject = context.getMethodTarget(Object.class);
            if (filterInit) {
                FilterConfig filterConfig = context.getMethodParam(0, FilterConfig.class);
                servletContext = null != filterConfig ? filterConfig.getServletContext() : null;
            } else if (targetObject instanceof ServletConfig) {
                servletContext = ((ServletConfig)targetObject).getServletContext();
            }
            if (null != servletContext) {
                Servlets.setVersion(servletContext.getMajorVersion(), servletContext.getMinorVersion());
            }
        }
        if (!filterInit && null != (request = this.getRequest(context))) {
            ip.setUpstreamToken(request.getHeader("NUDGE_TOKEN"));
        }
    }

    @Override
    public void exitAsTransaction(EventContext context) {
        Enumeration names;
        Cookie[] cookies;
        HttpServletRequest request = this.getRequest(context);
        HttpServletResponse response = this.getResponse(context);
        if (null == request) {
            return;
        }
        ProtocolFacade protocol = context.getProtocol();
        Configuration config = context.getConfig();
        if (config.isRumActivated() && null != (cookies = request.getCookies())) {
            for (Cookie c : cookies) {
                if (!"nudge".equals(c.getName())) continue;
                try {
                    protocol.setEndUserTiming(URLDecoder.decode(c.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        HashMap<String, String> additionalExtCodes = new HashMap<String, String>();
        if (config.isParamsAllowed()) {
            names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String paramValue;
                String param = (String)names.nextElement();
                if (!config.isParamAllowed(param)) continue;
                String[] paramValues = request.getParameterValues(param);
                if (paramValues.length == 1) {
                    paramValue = paramValues[0];
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < paramValues.length; ++i) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(paramValues[i]);
                    }
                    paramValue = sb.toString();
                }
                additionalExtCodes.put("http.param." + param, paramValue);
            }
        }
        if (config.isHeadersAllowed()) {
            names = request.getHeaderNames();
            while (names.hasMoreElements()) {
                String header = (String)names.nextElement();
                String headerValue = request.getHeader(header);
                if (null == headerValue || !config.isHeaderAllowed(header)) continue;
                additionalExtCodes.put("http.request.header." + header, headerValue);
            }
        }
        InstrumentationPoint ip = context.getInstrumentationPoint();
        protocol.setType("Servlet").setCode(request.getRequestURI()).addExtendedCode(ExtendedCode.extCode("http.method", request.getMethod())).addExtendedCode(ExtendedCode.extCode("http.request.header.User-Agent", request.getHeader("User-Agent"))).setException(context.getThrownException()).setUpstreamToken(ip.getUpstreamToken());
        if (config.isCaptureHttpClientIp()) {
            protocol.addExtendedCode(ExtendedCode.extCode("http.clientip", this.getClientIp(request)));
        }
        try {
            int version = Servlets.getVersion();
            if (version >= 24) {
                protocol.addExtendedCode(ExtendedCode.extCode("http.response.header.Content-Type", response.getContentType()));
            }
            if (version >= 30) {
                int status = response.getStatus();
                protocol.addExtendedCode(ExtendedCode.extCode("http.status", Integer.toString(status)));
                if (status >= 400) {
                    protocol.setError("Http status: " + status, ip.getStartTime());
                }
                if (config.isHeadersAllowed()) {
                    for (String header : response.getHeaderNames()) {
                        String headerValue = response.getHeader(header);
                        if (null == headerValue || !config.isHeaderAllowed(header)) continue;
                        additionalExtCodes.put("http.response.header." + header, headerValue);
                    }
                }
            }
        }
        catch (LinkageError version) {
            // empty catch block
        }
        for (Map.Entry entry : additionalExtCodes.entrySet()) {
            protocol.addExtendedCode(ExtendedCode.extCode((String)entry.getKey(), (String)entry.getValue()));
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            protocol.addExtendedCode(ExtendedCode.extCode("http.session", session.getId()));
        }
    }

    private ServletContext getServletContext(EventContext context) {
        Object targetObject = context.getMethodTarget(Object.class);
        ServletContext servletContext = null;
        if (targetObject instanceof ServletConfig) {
            servletContext = ((ServletConfig)targetObject).getServletContext();
        } else if (targetObject instanceof FilterConfig) {
            servletContext = ((FilterConfig)targetObject).getServletContext();
        }
        return servletContext;
    }

    protected HttpServletResponse getResponse(EventContext context) {
        return context.getMethodParam(1, HttpServletResponse.class);
    }

    protected HttpServletRequest getRequest(EventContext context) {
        return context.getMethodParam(0, HttpServletRequest.class);
    }

    protected String getClientIp(HttpServletRequest request) {
        String ip = request.getRemoteAddr();
        for (String header : IP_HEADERS) {
            String[] parts;
            String value = request.getHeader(header);
            if (null == value || (parts = value.split(",")).length <= 0) continue;
            ip = parts[0].trim();
        }
        return ip;
    }
}

