/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.servlet;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public class JakartaHttpServletWeaver
extends AbstractAsmWeaver {
    private static final Set<String> SERVLET_METHODS = new HashSet<String>(Arrays.asList("service", "_jspService"));
    private static final String SERVLET_METHOD_SIGNATURE = "(Ljakarta/servlet/http/HttpServletRequest;Ljakarta/servlet/http/HttpServletResponse;)V";
    private static final String FILTER_METHOD = "doFilter";
    private static final String FILTER_METHOD_SIGNATURE_PREFIX = "(Ljakarta/servlet/ServletRequest;Ljakarta/servlet/ServletResponse;";
    private static final String FILTER_INIT_METHOD_SIGNATURE = "(Ljakarta/servlet/FilterConfig;)V";
    private static final String JAKARTA_HTTP_SERVLET = "jakarta/servlet/http/HttpServlet";
    private boolean isFilter = false;
    private boolean isServlet = false;

    public JakartaHttpServletWeaver() {
        super("Servlet", "org.nudge.probe.weave.servlet.JakartaHttpServletHandler");
    }

    @Override
    public boolean matches(ClassDef clazz, ClassLoader cl) {
        Set<String> interfaces = clazz.getAllInterfaces();
        this.isServlet = clazz.getName().equals(JAKARTA_HTTP_SERVLET) || clazz.getAllSuperNames().contains(JAKARTA_HTTP_SERVLET) || interfaces.contains("jakarta/servlet/jsp/HttpJspPage");
        this.isFilter = interfaces.contains("jakarta/servlet/Filter") || interfaces.contains("jakarta/servlet/FilterChain");
        return this.isServlet || this.isFilter;
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        String methodSignature = method.getSignature();
        String methodName = method.getName();
        boolean instrument = false;
        if (this.isServlet) {
            instrument |= SERVLET_METHODS.contains(methodName) && SERVLET_METHOD_SIGNATURE.equals(methodSignature);
        }
        if (this.isFilter) {
            instrument |= FILTER_METHOD.equals(methodName) && methodSignature.startsWith(FILTER_METHOD_SIGNATURE_PREFIX);
            instrument |= "init".equals(methodName) && methodSignature.equals(FILTER_INIT_METHOD_SIGNATURE);
        }
        return instrument;
    }
}

