/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.springmvc;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.nudge.probe.events.BaseEventHandler;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.ProtocolFacade;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringMvcControllerHandler
extends BaseEventHandler {
    @Override
    public void onEntering(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        if (ip.isInTx()) {
            ProtocolFacade protocol = context.getProtocol();
            protocol.setType(ip.getType());
            HttpServletRequest servletRequest = context.getMethodContext(0, HttpServletRequest.class);
            if (null != servletRequest) {
                String methodMapping;
                StringBuilder sb = new StringBuilder(servletRequest.getMethod());
                sb.append(" ").append(servletRequest.getContextPath());
                String classMapping = SpringMvcControllerHandler.getAnnotationValue(context.getMethodTarget(Object.class).getClass().getAnnotation(RequestMapping.class));
                if (null != classMapping) {
                    sb.append(classMapping);
                }
                if (null != (methodMapping = SpringMvcControllerHandler.getAnnotationValue(context.getMethodAnnotation(RequestMapping.class)))) {
                    sb.append(methodMapping);
                }
                protocol.setCode(sb.toString());
            }
        }
    }

    private static String getAnnotationValue(RequestMapping annotation) {
        String result = null;
        if (null != annotation) {
            Object[] value = annotation.value();
            if (value.length == 1) {
                result = value[0];
            } else if (value.length > 1) {
                result = Arrays.toString(value);
            }
        }
        return result;
    }
}

