/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.springmvc;

import java.util.HashSet;
import java.util.Set;
import org.nudge.dependency.ooa.AnnotationVisitor;
import org.nudge.dependency.ooa.ClassVisitor;
import org.nudge.dependency.ooa.FieldVisitor;
import org.nudge.dependency.ooa.Type;
import org.nudge.dependency.ooa.commons.GeneratorAdapter;
import org.nudge.probe.util.Checker;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public abstract class SpringMvcControllerWeaver
extends AbstractAsmWeaver {
    private static final String NUDGE_SERVLET_REQUEST = "nudge#servletRequest";
    private final Type servletRequest;
    public Boolean servletRequestIsLoadable;
    private static final Type AUTOWIRED_ANNOTATION = Type.getObjectType("org/springframework/beans/factory/annotation/Autowired");
    static final String REQUEST_MAPPING_ANNOTATION = "org/springframework/web/bind/annotation/RequestMapping";
    static final String CONTROLLER_ANNOTATION = "org/springframework/stereotype/Controller";
    final Set<String> matchingMethods = new HashSet<String>();

    public SpringMvcControllerWeaver(String id, String springMvcHandler, Type servletRequest, ClassLoader cl) {
        super(id, springMvcHandler);
        this.servletRequest = servletRequest;
        this.servletRequestIsLoadable = this.canLoadClass(cl, servletRequest);
    }

    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        if (!def.getAnnotations().contains(CONTROLLER_ANNOTATION)) {
            return false;
        }
        boolean hasMethodMatch = false;
        for (MethodDef md : def.getMethods()) {
            boolean match = this.methodMatch(md);
            if (!match) continue;
            this.matchingMethods.add(md.getCacheKey());
            hasMethodMatch = true;
        }
        return hasMethodMatch;
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        return this.matchingMethods.contains(method.getCacheKey());
    }

    boolean methodMatch(MethodDef method) {
        Set<String> annotations = method.getAnnotations();
        return annotations.contains(REQUEST_MAPPING_ANNOTATION);
    }

    protected boolean canLoadClass(ClassLoader cl, Type classType) {
        boolean isLoadable = false;
        try {
            isLoadable = cl.loadClass(classType.getClassName()) != null;
        }
        catch (Exception e) {
            isLoadable = false;
        }
        return isLoadable;
    }

    @Override
    public int addClassFieldsSize() {
        return 1;
    }

    @Override
    public void addClassField(ClassDef type, int i, ClassVisitor cv) {
        FieldVisitor fv = cv.visitField(2, NUDGE_SERVLET_REQUEST, this.servletRequest.getDescriptor(), this.servletRequest.getDescriptor(), null);
        AnnotationVisitor av = fv.visitAnnotation(AUTOWIRED_ANNOTATION.getDescriptor(), false);
        av.visitEnd();
        fv.visitEnd();
    }

    @Override
    public int contextFieldsSize() {
        return 1;
    }

    @Override
    public void contextFieldLoadValue(ClassDef type, MethodDef method, int i, GeneratorAdapter mv, ClassLoader classLoader) {
        Checker.checkArgument(0 == i);
        mv.visitVarInsn(25, 0);
        mv.getField(Type.getObjectType(type.getName()), NUDGE_SERVLET_REQUEST, this.servletRequest);
    }
}

