/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.swing;

import java.lang.reflect.Modifier;
import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.ClassDef;

public class ActionListenerWeaver
extends AbstractWeaver {
    @Override
    public boolean matches(ClassDef clazz, ClassLoader cl) {
        for (String name : clazz.getAllInterfaces()) {
            if (!"java/awt/event/ActionListener".equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean instrument(CtMethod m) throws CannotCompileException, NotFoundException {
        String method;
        if (Modifier.isPublic(m.getModifiers()) && !Modifier.isStatic(m.getModifiers()) && (method = m.getName()).startsWith("actionPerformed")) {
            this.build(m);
            return true;
        }
        return false;
    }

    private void build(CtMethod method) throws CannotCompileException, NotFoundException {
        String signature = method.getLongName();
        StringBuffer buf = new StringBuffer();
        buf.append("{ ");
        buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("  logger.entering(org.nudge.probe.EventType.SWING,\"" + signature + "\"); ");
        buf.append("} ");
        method.insertBefore(buf.toString());
        this.addCatch(method);
        buf = new StringBuffer(1000);
        buf.append("{ ");
        buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("  logger.exiting( org.nudge.probe.EventType.SWING, \"" + signature + "\" ); ");
        buf.append("} ");
        method.insertAfter(buf.toString(), true);
    }
}

