/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.swing;

import java.lang.reflect.Modifier;
import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtClass;
import org.nudge.javassist.CtField;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.jvm.JvmInfo;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.ClassDef;

public class JComponentWeaver
extends AbstractWeaver {
    public JComponentWeaver(JvmInfo jvmInfo) {
        super(jvmInfo);
    }

    @Override
    public boolean matches(ClassDef clazz, ClassLoader cl) {
        return "javax/swing/JComponent".equals(clazz.getSuperName());
    }

    @Override
    public boolean beforeInstrument(CtClass clazz) throws CannotCompileException, NotFoundException {
        clazz.addField(CtField.make("private boolean nudgeCheckEdt = true;", clazz));
        clazz.addField(CtField.make("private int nudgeCheckEdtCounter;", clazz));
        clazz.addField(CtField.make("private int nudgeCheckEdtThreshold = 1;", clazz));
        return true;
    }

    @Override
    public boolean instrument(CtMethod m) throws CannotCompileException, NotFoundException {
        String method;
        if (Modifier.isPublic(m.getModifiers()) && !Modifier.isStatic(m.getModifiers()) && ((method = m.getName()).startsWith("put") || method.startsWith("load") || method.startsWith("remove"))) {
            this.build(m);
            this.getJvmInfo().enableComponent("swing", "swing");
            return true;
        }
        return false;
    }

    private void build(CtMethod method) throws CannotCompileException, NotFoundException {
        StringBuilder buf = new StringBuilder(1000);
        buf.append("{ ");
        buf.append("   if( nudgeCheckEdt && ++nudgeCheckEdtCounter >= nudgeCheckEdtThreshold ) { ");
        buf.append("      if( !javax.swing.SwingUtilities.isEventDispatchThread() ) { ");
        buf.append("         org.nudge.probe.NudgeLogger log = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("         nudgeCheckEdt = log.swingThreadingAntiPattern(); ");
        buf.append("      } else { ");
        buf.append("         nudgeCheckEdtThreshold += 1; ");
        buf.append("      } ");
        buf.append("      nudgeCheckEdtCounter = 0; ");
        buf.append("   } ");
        buf.append("} ");
        method.insertBefore(buf.toString());
        this.addCatch(method);
    }
}

