/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.ws;

import java.util.HashSet;
import java.util.Set;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public class JaxRpcWeaver
extends AbstractAsmWeaver {
    private static final String JAVA_RMI_REMOTE = "java/rmi/Remote";
    private static final String JAX_RPC_STUB = "javax/xml/rpc/Stub";
    private Set<String> methods = new HashSet<String>();

    public JaxRpcWeaver() {
        super("JAX-RPC", "org.nudge.probe.weave.ws.JaxRpcHandler");
    }

    @Override
    public boolean matches(ClassDef clazz, ClassLoader cl) {
        boolean rmiRemote = false;
        boolean rpcStub = false;
        for (String name : clazz.getAllInterfaces()) {
            rmiRemote = rmiRemote || JAVA_RMI_REMOTE.equals(name);
            rpcStub = rpcStub || JAX_RPC_STUB.equals(name);
        }
        return rpcStub && rmiRemote;
    }

    @Override
    protected void beforeInstrument(byte[] classBytes, String className, ClassLoader cl) {
        ClassDef classDef = ClassDef.fromBytecode(classBytes, cl);
        for (String i : classDef.getAllInterfaces()) {
            ClassDef interfaceDef = ClassDef.fromClassLoaderResource(i, cl);
            if (null == interfaceDef || !interfaceDef.getAllInterfaces().contains(JAVA_RMI_REMOTE)) continue;
            for (MethodDef method : interfaceDef.getMethods()) {
                this.methods.add(method.getCacheKey());
            }
        }
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        return method.isPublic() && (this.methods.isEmpty() || this.methods.contains(method.getCacheKey()));
    }
}

