/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.ws;

import jakarta.xml.ws.BindingProvider;
import org.nudge.probe.events.BaseEventHandler;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;

public class WebServiceJakartaHandler
extends BaseEventHandler {
    @Override
    public void onEntering(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        if (ip.isDefineTx()) {
            return;
        }
        Object methodTarget = context.getMethodTarget(Object.class);
        boolean isBindingProvider = methodTarget instanceof BindingProvider;
        InstrumentationPoint previous = ip.getPrevious();
        if (!isBindingProvider && null != previous && previous.getType().equals("Servlet")) {
            ip.makeDefineTx();
            return;
        }
        if (isBindingProvider || !ip.isBeyondOutput() && !ip.isDefineOutput()) {
            ip.makeDefineOutput(true);
        }
    }

    @Override
    protected void exitAsOutput(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        String code = ip.getMethod();
        String endPoint = null;
        Object methodTarget = context.getMethodTarget(Object.class);
        if (methodTarget instanceof BindingProvider) {
            endPoint = (String)((BindingProvider)methodTarget).getRequestContext().get("jakarta.xml.ws.service.endpoint.address");
            code = null != endPoint ? String.format("%s/%s", endPoint, context.getMethodName()) : context.getMethodName();
        }
        context.getProtocol().createOrUpdateLayerItem(ip.getStartTime(), "JAX-WS", code, ExtendedCode.extCode("jaxws.endpoint", endPoint), ExtendedCode.extCode("jaxws.method", context.getMethodName())).addCall(context);
    }
}

