/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.ws;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public class WebServiceWeaver
extends AbstractAsmWeaver {
    private static final Set<String> ANNOTATIONS = new HashSet<String>(Arrays.asList("javax/jws/WebService", "javax/xml/ws/WebServiceClient"));
    private final Set<String> filteredMethods = new HashSet<String>();

    public WebServiceWeaver() {
        super("JAX-WS", "org.nudge.probe.weave.ws.WebServiceHandler");
    }

    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        if ("javax/xml/ws/Service".equals(def.getSuperName())) {
            return false;
        }
        for (String name : def.getAnnotations()) {
            if (!ANNOTATIONS.contains(name)) continue;
            return true;
        }
        for (String interfaceName : def.getAllInterfaces()) {
            ClassDef interfaceDef = ClassDef.fromClassLoaderResource(interfaceName, cl);
            if (null == interfaceDef) continue;
            for (String annotation : interfaceDef.getAnnotations()) {
                if (!ANNOTATIONS.contains(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void beforeInstrument(byte[] classBytes, String className, ClassLoader cl) {
        ClassDef classDef = ClassDef.fromBytecode(classBytes, cl);
        for (String interfaceName : classDef.getAllInterfaces()) {
            ClassDef interfaceDef;
            if (interfaceName.startsWith("org/ow2/easybeans") || interfaceName.startsWith("org/apache/cxf/") || interfaceName.startsWith("javax/") || interfaceName.startsWith("java/") || interfaceName.startsWith("org/springframework/aop") || interfaceName.startsWith("org/springframework/context") || null == (interfaceDef = ClassDef.fromClassLoaderResource(interfaceName, cl))) continue;
            for (MethodDef interfaceMethod : interfaceDef.getMethods()) {
                this.filteredMethods.add(interfaceMethod.getCacheKey());
            }
        }
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        return method.isPublicInstanceMethod() && (this.filteredMethods.isEmpty() || this.filteredMethods.contains(method.getCacheKey()));
    }
}

