"use strict";const{execSync}=require("child_process");const getUuid=require('uuid-by-string');var osu=require('node-os-utils');var pjson=require('./package.json');const folderHash=require('folder-hash');var sizeof=require('object-sizeof');const path=require("path");const crypto=require('crypto');const{Worker,isMainThread,parentPort,workerData}=require('node:worker_threads');const request=require('request');const os=require('os');const osPlatform=os.platform();const osWin=/^win/i.test(osPlatform);const osLinux=/^linux/i.test(osPlatform);const osMacOs=/^darwin/i.test(osPlatform);const fs=require("fs");const rawdata_pb=require('./rawdata_pb.js');exports.NudgeExporter={NudgeSpanExporter:void 0};const core=require("@opentelemetry/core");const SC=require('@opentelemetry/semantic-conventions');const{NetTransportValues,SemanticAttributes,SemanticResourceAttributes}=require('@opentelemetry/semantic-conventions');const{BasicTracerProvider}=require('@opentelemetry/sdk-trace-base');require('./SemanticAttributesNEW.js');const browser=require('bowser');const indexRawdata_MIN=-1;let argv=process.argv;let appJS=argv.length>=1?argv[1]:"";let MyConsole;function getLast(This){return This.length>0?This[This.length-1]:undefined;}
function setLast(This,e)
{if(This.length>0)
This[This.length-1]=e;}
function includesOneField(o,a)
{if(!Array.isArray(a))
return false;for(const f in o)
{if(a.includes(f))
return true;}
return false;}
function findLastIndex(f)
{for(let i=this.length-1;i>=0;i--)
{if(f(this[i],i))
return i;}
return-1;}
function findIndexes(f)
{let indexes=this.reduce((a,e,i)=>{if(f(e))
a.push(i);return a;},new Array());return indexes;}
function count(f)
{let n=this.reduce((a,e)=>{if(f(e))
a++;return a;},0);return n;}
function toUpperCase1(){return this[0].toUpperCase()+this.substring(1);}
var Headers={"content-length-uncompressed":"Content-Length","content-length":"Content-Length"}
var filename_N=0;function getTimestamp(t)
{return parseInt(t[0]*1000+t[1]/1000000);}
class Serveur{constructor(name,type,nom,instrument){this.name=name;this.type=type;this.nom=nom;this.instrument=instrument;}};class UuidDictionary
{uuidDictionary;constructor(){this.uuidDictionary=new Object();}
makeUUID(key)
{if(typeof this.uuidDictionary[key]==='undefined')
this.uuidDictionary[key]=generateUUID();return this.uuidDictionary[key];}
getUUID(key)
{return this.uuidDictionary[key]?this.uuidDictionary[key]:generateUUID.Null;}};class TreeProfile
{nodeIds;nodes;startTime;endTime;nTime;node;constructor(start,end,nTime,nodeIds,nodes,node)
{this.endTime=end;this.startTime=start;this.nodeIds=[...nodeIds];this.nTime=nTime;this.nodes=nodes;this.node=node;}};class AnalyseDataProfiler{timeLimitAnalyseProfiler;timeAnalyseDataProfiler;dataProfiler;treeProfiles;#tag;#rgxCallOrigin;numberCallOrigin;static rootCallOrigin='callOriginal_ATK_';constructor(tag){this.timeAnalyseDataProfiler=0;this.dataProfiler=undefined;this.treeProfiles=new Array();this.#tag=tag;this.#rgxCallOrigin=new RegExp(`^${AnalyseDataProfiler.rootCallOrigin}[0-9a-z]+$`,'i');this.numberCallOrigin=-1;this.timeLimitAnalyseProfiler=tag?.timeLimitAnalyseProfiler>=0?tag.timeLimitAnalyseProfiler:1000;}
analyseDataProfiler(dataProfiler)
{let t=Date.now();this.dataProfiler=dataProfiler;let timeStartSample=0;let timeEndSample=0;this.treeProfiles=new Array();let tGetParentAlls=new Array();let noTimeout=true;if(this.numberCallOrigin==-1)
this.getNumber();for(let indexSamples=0;indexSamples<this.dataProfiler.samples.length&&noTimeout;indexSamples++,noTimeout=Date.now()-t<this.timeLimitAnalyseProfiler)
{let id=this.dataProfiler.samples[indexSamples];let findIndexBefore=-1;for(let j=indexSamples-1;j>=0&&findIndexBefore==-1;j--)
if(this.dataProfiler.samples[j]==id)
findIndexBefore=j;let indexNode=this.dataProfiler.nodes.findIndex(node=>node.id==id);let node=this.dataProfiler.nodes[indexNode];if(findIndexBefore==-1)
{let[nodes,tGetParentAll]=this.getParentsAll(node);tGetParentAlls.push(tGetParentAll);let nodeIds=nodes.reduce((a,e)=>{a.push(e.id);return a;},new Array());let j=indexSamples;for(;j<this.dataProfiler.samples.length&&this.dataProfiler.samples[j]==id;j++)
{timeEndSample+=this.dataProfiler.timeDeltas[j];this.dataProfiler.nodes[indexNode].hitCount--;}
let treeProfile=new TreeProfile(timeStartSample,timeEndSample,j-indexSamples,nodeIds,nodes,node);this.treeProfiles.push(treeProfile);timeStartSample=timeEndSample;indexSamples=j-1;}
else
{let tp=this.treeProfiles.find(x=>x.node.id==id);let[nodes,tGetParentAll]=[tp.nodes,-1];tGetParentAlls.push(tGetParentAll);let nodeIds=tp.nodeIds;let j=indexSamples;for(;j<this.dataProfiler.samples.length&&this.dataProfiler.samples[j]==id;j++)
{timeEndSample+=this.dataProfiler.timeDeltas[j];this.dataProfiler.nodes[indexNode].hitCount--;}
let treeProfile=new TreeProfile(timeStartSample,timeEndSample,j-indexSamples,nodeIds,nodes,node);this.treeProfiles.push(treeProfile);timeStartSample=timeEndSample;indexSamples=j-1;}}
let nParentAll=count.call(tGetParentAlls,x=>{return x==-1;});this.timeAnalyseDataProfiler=Date.now()-t;return{treeProfiles:this.treeProfiles,tGetParentAlls:tGetParentAlls,timeout:!noTimeout,nParentAll:nParentAll};};getParentsAll(node)
{let treeParentsAll=new Array();treeParentsAll.push(node);let t=Date.now();for(let nodes=this.getParents(node);getLast(treeParentsAll).id!=1;nodes=this.getParents(node))
{if(nodes.length>1)
{MyConsole.warn(`${node.id} à plusieurs parents ❌ ${nodes.reduce((a, e) => { a += e.id + ";"; return a; }, "")}`);treeParentsAll.push(node[0]);node=nodes[0];}
else if(nodes.length==1)
{treeParentsAll.push(nodes[0]);node=nodes[0];}
else
{MyConsole.warn(`${node.id} pas de parent ❌`);return treeParentsAll;}}
return[treeParentsAll,Date.now()-t];};getParents(node)
{let nodes=this.dataProfiler.nodes.reduce((a,e)=>{if(Array.isArray(e.children)&&e.children.includes(node.id))
{a.push(e);}
return a;},new Array());return nodes;};getTreeNodesChildren(node)
{let treeNodes=this.treeProfiles.reduce((a,e)=>{let indexNode=e.nodeIds.findIndex(nId=>nId==node.id);indexNode--;if(indexNode>=0)
{let ee=new TreeProfile(e.startTime,e.endTime,e.nTime,e.nodeIds.slice(0,indexNode+1),e.nodes.slice(0,indexNode+1));a.push(ee);}
return a;},new Array());return treeNodes;}
get Tag(){return this.#tag;}
set Tag(e){this.#tag=e;}
findIndexCallOrigin(traceId)
{if(traceId==undefined)
return this.dataProfiler.nodes.findIndex(e=>this.#rgxCallOrigin.test(e.callFrame.functionName));else
{let rgx=new RegExp(`^${AnalyseDataProfiler.rootCallOrigin}${traceId}$`,"i");return this.dataProfiler.nodes.findIndex(e=>rgx.test(e.callFrame.functionName));}}
getNumber()
{this.numberCallOrigin=count.call(this.dataProfiler.nodes,e=>this.#rgxCallOrigin.test(e.callFrame.functionName));return this.numberCallOrigin;}};class OSU
{constructor(refreshTime=global.configurationAgentNodeJS.Profiler.refreshStopStartRecyclage)
{this.cpuPercentage=undefined;this.dateNow=undefined;let cpuUsageDateNow1=Date.now();this.cpuUsage=process.cpuUsage();this.cpuPercentageNode=undefined;this.openFd=undefined;this.oss=undefined;this.mem=undefined;this.oc=undefined;setInterval((This)=>getAllOSU(This),refreshTime,this);function getAllOSU(This)
{osu.users.openedCount().then(oc=>{This.oc=oc;});osu.mem.info().then(mi=>{This.mem=mi;});osu.cpu.usage().then(cpuPercentage=>{This.cpuPercentageNode=cpuPercentage;This.dateNow=Date.now();});osu.os.oos().then(oss=>{This.oss=oss;});osu.openfiles.openFd().then((v)=>{This.openFd=v;});let cpuUsageDateNow2=Date.now();let cpuUsage=process.cpuUsage();This.cpuPercentage=100*((cpuUsage.system+cpuUsage.user)-(This.cpuUsage.system+This.cpuUsage.user))/((cpuUsageDateNow2-cpuUsageDateNow1)*1000);cpuUsageDateNow1=cpuUsageDateNow2;This.cpuUsage=cpuUsage;}}};let oSU=undefined;if(isMainThread)
oSU=new OSU(global.configurationAgentNodeJS?.NodeJS?.refreshLoadCPU);class NudgeSpanExporter{constructor(options){const deepMAX=5;this._finishedSpans=[];this._finishedSpansALL=[];this.inspector=options.inspector;this.dns=undefined;this.resourceOTEL=options.OTEL;this.components=undefined;this._stopped=false;this._uuid=options.uuid;this._Agentiduuid=generateUUID();this._url=options.url;this._headers=options.headers;this._exportTimeoutMillis=options.exportTimeoutMillis?options.exportTimeoutMillis:5000;this._method=options.method.toLowerCase();this._cmpt=0;this.transactions=new Array();this.transaction=undefined;this.sendTransaction=undefined;this.rawdata=undefined;this.flushRawdata=undefined;this.urlDictionary=new UuidDictionary();this.dataProfilerFilter=new Array();this.dataProfilerFilter_N=0;this.dataProfiler=new Array();this.dataProfiler_N=0;this.dataHeap=new Array();this.dataHeap_N=0;this.recordedDataHeap=new Array();this.recordedDataHeap_N=0;this.f_callback_getDrives_response=undefined;this.allDrives=undefined;this.worker=undefined;this.subChannel=undefined;if(options.MyConsole!=undefined)
{MyConsole=options.MyConsole;global.MyConsole=options.MyConsole;}
{this.worker=new Worker(path.resolve(__dirname,"./worker.js"));this.subChannel=new MessageChannel();this.subChannel.port2.on('message',(v,t)=>{switch(v.msg)
{case'test_response':let n=0;n++;break;case'getDrives_response':this.allDrives=v.value;if(typeof this.f_callback_getDrives_response=='function')
this.f_callback_getDrives_response(this.allDrives);break;case'the worker is sending this':this.worker.postMessage({msg:'getDrives',timeRefresh:global.configurationAgentNodeJS['Drives']['refreshScanDrives']});this.intervalGetDrive=setInterval((This)=>{This.worker.postMessage({msg:'getDrives'});},global.configurationAgentNodeJS['Drives']['refreshScanDrives']*60*1000,this);break;}});this.worker.postMessage({port1:this.subChannel.port1},[this.subChannel.port1]);}
let promises=new Array();let components=new Array();let getMainModule=function(m,getHash=true,deep=0)
{if(deep>deepMAX)
return;try
{let rFilename=require.resolve(m.filename);let dir=path.dirname(rFilename);let name=path.basename(rFilename);if(dir.includes(`${path.sep}node_modules${path.sep}`))
{let dirs=dir.split(path.sep);let iNodeModules=dirs.indexOf('node_modules');if(dirs.length-iNodeModules-2>0)
dirs.splice(iNodeModules+2,dirs.length-iNodeModules-2);dir=dirs.join(path.sep);let pj=path.join(dir,"package.json");if(fs.existsSync(pj))
{let component=new proto.org.nudge.buffer.Component();if(m.id!=undefined)component.setKey(m.id);if(m.filename!=undefined)component.setFilename(m.filename);const pjX=require(pj);let maevenComponent=new proto.org.nudge.buffer.MavenComponent();maevenComponent.setVersion(pjX.version);maevenComponent.setArtifactid(pjX.name+'@'+deep);component.addMavencomponents(maevenComponent);if(getHash===true)
{const options={algo:'sha1',encoding:'hex',folders:{exclude:['.*','node_modules','test_coverage']},files:{include:['*.js','*.json']},};let p=folderHash.hashElement(dir,options).then((resolve,reject)=>{if(resolve)
{component.setFilesha1(resolve.hash.toUpperCase());let i=components.indexOf(e=>e.getFilename()==component.getFilename());if(i<0)
components.push(component);else
MyConsole.log(`Doublons : ${component.getFilename()}`);}else if(reject)
{MyConsole.error('Hashing failed:',reject);}});promises.push(p);}}
else
{if(global.configurationAgentNodeJS.Console.logDetail===true)
MyConsole.error(`Erreur Components : Module not found ${pj}`);}}
else
{if(global.configurationAgentNodeJS.Console.logDetail===true)
MyConsole.error(`Erreur Components : Not a module ${dir+path.sep+name}`);}}
catch(e)
{MyConsole.error(`Erreur Components : ${e.message}`);return;}
m.children.forEach(mm=>{getMainModule.call(this,mm,getHash,deep++);});}
this.initMainModule=function()
{let start=Date.now();getMainModule.call(this,process.mainModule);let duree=Date.now()-start;global.MyConsole.info(`initMainModule() -> ${duree}() ms`);Promise.all(promises).then(()=>{this.components=components;});return{promises:promises,components:this.components};}
this.addDataProfilerFilter=function(data)
{let filename=path.resolve(__dirname,`./inspector/profiling_dataProfilingFilter_${this.dataProfilerFilter_N++}.json`);if(data&&this.dataProfilerFilter_N<60)toDisk(filename,data);return filename;}
this.addDataProfiler=function(data)
{let filename=path.resolve(__dirname,`./inspector/profiling_dataProfiling_${this.dataProfiler_N++}.json`);if(data&&this.dataProfiler_N<60)toDisk(filename,data);return filename;}
this.getDataProfiler=function(dataProfiler_N)
{let filename=path.resolve(__dirname,`./inspector/profiling_dataProfiling_${dataProfiler_N}.json`);return fromDisk(filename);}
this.addDataPreciseProfiler=function(data)
{let filename=path.resolve(__dirname,`./inspector/profiling_dataPreciseProfiling_${this.dataProfiler_N}.json`);if(data&&this.dataProfiler_N<60)toDisk(filename,data);return filename;}
this.addDataHeap=function(data)
{let filename=path.resolve(__dirname,`./inspector/profiling_dataHeap_${this.dataHeap_N++}.json`);if(data&&this.dataHeap_N<60)toDisk(filename,data);return filename;}
this.addDataRecordedDataHeap=function(data)
{let filename=path.resolve(__dirname,`./inspector/profiling_recordedDataHeap_${this.recordedDataHeap_N++}.json`);if(data&&this.recordedDataHeap_N<60)toDisk(filename,{head:data.head,samples:data.samples});return filename;}
this.gestionnaireSpans=function(){let start=Date.now();let end1;let p1;if(global.configurationAgentNodeJS?.NodeJS?.profilerV8===true)
p1=this.inspector.profiler.stop().then(value=>{end1=Date.now()-start;value.startTimeX=this.inspector.profiler.startTimeX;return value;});Promise.all([p1]).then((values)=>{if(global.configurationAgentNodeJS?.NodeJS?.profilerV8===true)
{this.inspector.profiler.start().then(()=>{this.inspector.profiler.startTimeX=Date.now();let end2=Date.now()-start;global.inspector.profile.blocked=false;MyConsole.log(`Reception stop() : ${end1} ms , Reception start() : ${end2} ms`);});let dataProfiler=values[0];let aDataProfiler=new AnalyseDataProfiler({timeLimitAnalyseProfiler:1500});let rDataProfiler=aDataProfiler.analyseDataProfiler(dataProfiler);if(global.configurationAgentNodeJS?.Console?.logDetail===true)
{MyConsole[`${rDataProfiler.timeout === true ? 'warn' : 'log'}`](`analyseDataProfiler() ${rDataProfiler.timeout === true ? 'timeout' : ''} , Size dataProfiler ${parseInt(sizeof(dataProfiler) / 1024)} Ko, [nodes=${dataProfiler?.nodes?.length}] :[samples=${dataProfiler?.samples?.length}] - [treeProfiles=${rDataProfiler?.treeProfiles?.length}] [nParentAll=${rDataProfiler?.nParentAll}] -> ${(rDataProfiler?.nParentAll / rDataProfiler?.treeProfiles?.length * 100).toFixed(0)}% - ${aDataProfiler.timeAnalyseDataProfiler} ms`);}
if(aDataProfiler.numberCallOrigin>0)
global.inspector.profile.dataProfiler.add(aDataProfiler);if(global.configurationAgentNodeJS?.NodeJS?.recordProfiler===true)
{let f=this.addDataProfiler(dataProfiler);aDataProfiler.Tag={filename:f};}}
this.gestionnaireSpans_SUITE(global.inspector.profile.dataProfiler.dataAnalyseDataProfilers);});}
this.gestionnaireSpans_SUITE=function(dataAnalyseDataProfilers)
{let functionPointEntreeTimeLineNodes=new Array(dataAnalyseDataProfilers.length);functionPointEntreeTimeLineNodes.fill({N:0,M:0,I:0},0);this.createRawdata();let spansX=this.getFinishedSpans();let bufferSizeSpan=parseInt(global.configurationAgentNodeJS?.NodeJS?.bufferSizeSpan);if(this._finishedSpansALL.length+spansX.length-bufferSizeSpan>0)
this._finishedSpansALL.splice(0,this._finishedSpansALL.length+spansX.length-bufferSizeSpan);this._finishedSpansALL.push(...spansX);MyConsole.log(`Nombre de span ${spansX.length}`);for(let iSps=0;iSps<spansX.length;iSps++)
{let sps=spansX[iSps];let attributes=sps['attributes'];let keys=Object.keys(attributes);let HTTP=keys.findIndex(k=>{return k.startsWith('http.');})>=0;let NET=keys.findIndex(k=>{return k.startsWith('net.');})>=0;let DB=keys.findIndex(k=>{return k.startsWith('db.');})>=0;let GQL=keys.findIndex(k=>{return k.startsWith('graphql.');})>=0;let SERVEUR=this.getNameType(attributes);let INSTRUMENT=this.getInstrumentType(sps);let uuid=getUuid(sps['_spanContext']['traceId']);this.transaction=this.transactions.find(t=>t.getUuid()==uuid);if(!this.transaction)
{this.transaction=new proto.org.nudge.buffer.Transaction();this.transactions.push(this.transaction);this.transaction.TAG={correlationid:0,urlid:1,serveur:undefined,};this.transaction.setUuid(uuid);attributes[SemanticAttributes.UUID]=this.transaction.getUuid();this.transaction.setSessionid(global.configurationAgentNodeJS.Nudge?.sessionId);}
if(NET)
{let n=0;}
if((SERVEUR||HTTP)&&((sps.kind===1||sps.kind===0)||(sps.parentSpanId==undefined)))
{this.transaction.setUpstreamtxid(sps?._spanContext?.traceId);this.transaction.setUpstreamcorrelationid(this.transaction.TAG.correlationid++);let peer="";if(typeof attributes[SemanticAttributes.NET_PEER]!='undefined')
peer=attributes[SemanticAttributes.NET_PEER]+(typeof attributes[SemanticAttributes.NET_PEER_PORT]!='undefined'?`:${attributes[SemanticAttributes.NET_PEER_PORT]}`:'');else if(typeof attributes[SemanticAttributes.NET_PEER_NAME]!='undefined')
peer=attributes[SemanticAttributes.NET_PEER_NAME]+(typeof attributes[SemanticAttributes.NET_PEER_PORT]!='undefined'?`:${attributes[SemanticAttributes.NET_PEER_PORT]}`:'');else if(typeof attributes[SemanticAttributes.NET_PEER_IP]!='undefined')
peer=attributes[SemanticAttributes.NET_PEER_IP]+(typeof attributes[SemanticAttributes.NET_PEER_PORT]!='undefined'?`:${attributes[SemanticAttributes.NET_PEER_PORT]}`:'');let keysResponse=keys.filter(k=>{return k.startsWith('http.request.header.');});keysResponse.forEach(kr=>{let headerName=kr.replace('http.request.header.','').replace(/_/gm,'-');headerName=Headers[headerName]!=undefined?Headers[headerName]:headerName;headerName=headerName.split('-').map(e=>toUpperCase1.call(e)).join('-');if(true||["Content-Type"].includes())
{let kv=new proto.org.nudge.buffer.KeyValue();kv.setKey(headerName);kv.setValue(Array.isArray(attributes[kr])?attributes[kr].map((e)=>e.toString()).join(','):attributes[kr].toString());this.transaction.addHeaders(kv);}});this.addAllExtendedcodes(sps);let name=sps['name'];this.transaction.setUrl(name);let st=getTimestamp(sps['startTime']);let et=getTimestamp(sps['endTime']);this.transaction.setStarttime(st);this.transaction.setEndtime(et);let url=attributes[SemanticAttributes.HTTP_URL];if(url!=undefined)
{if(name.startsWith('HTTP '))
this.transaction.setUrl(`${name.replace('HTTP ','')} ${url}`);this.transaction.TAG.url=this.transaction.getUrl();this.transaction.TAG.traceId=sps._spanContext.traceId;let params=url.split('?',2);if(params.length>=1)
{let param=new proto.org.nudge.buffer.Param();param.setKey("url");param.setValue(params[0]);param.setType('string');this.transaction.addParams(param,0);}
if(params.length>=2)
{params=params[1].split('&');params=params.map(e=>{let t=e.split('=',2);if(t.length==1)t.push('');return{key:t[0],value:t[1]};});params.forEach((kv,iKV)=>{let param=new proto.org.nudge.buffer.Param();param.setKey(kv.key);param.setValue(kv.value);param.setType('string');this.transaction.addParams(param,iKV+1);});}}
if(typeof attributes[SemanticAttributes.HTTP_STATUS_CODE]!='undefined')
this.transaction.setRespstatuscode(attributes[SemanticAttributes.HTTP_STATUS_CODE]);if(sps.errors&&Array.isArray(sps.errors))
{sps.errors.forEach(se=>{let error=new proto.org.nudge.buffer.Error();error.setCode(`${se.constructor.name}`);error.setStarttime(getTimestamp(sps['startTime']));error.setMessage(se.message);error.setStacktrace(se.stack.replace(/\n\s*at\s*/igm,'#'));error.setJvmstacktrace(se.stack.replace(/\n/gm,'\r\n\t'));this.transaction.addErrors(error);});}
if(attributes&&(includesOneField(attributes,[SemanticAttributes.HTTP_ERROR_NAME,SemanticAttributes.HTTP_ERROR_MESSAGE,SemanticAttributes.HTTP_STACKTRACE])||(attributes[SemanticAttributes.HTTP_STATUS_CODE]!=undefined)&&attributes[SemanticAttributes.HTTP_STATUS_CODE]>=400))
{let error=new proto.org.nudge.buffer.Error();if(typeof attributes[SemanticAttributes.HTTP_STATUS_CODE]!='undefined')
error.setCode(`Http status: ${attributes[SemanticAttributes.HTTP_STATUS_CODE].toString()}`);error.setStarttime(getTimestamp(sps['startTime']));if(typeof attributes[SemanticAttributes.HTTP_ERROR_MESSAGE]!='undefined')
error.setMessage(`${attributes[SemanticAttributes.HTTP_ERROR_MESSAGE]} - ${attributes[SemanticAttributes.HTTP_ERROR_NAME] ? attributes[SemanticAttributes.HTTP_ERROR_NAME] : ''}`);else if(typeof attributes[SemanticAttributes.HTTP_STATUS_CODE]!='undefined'&&parseInt(attributes[SemanticAttributes.HTTP_STATUS_CODE])>=400)
error.setMessage(`${attributes[SemanticAttributes.HTTP_STATUS_TEXT] ? attributes[SemanticAttributes.HTTP_STATUS_TEXT] : ''} - ${attributes[SemanticAttributes.HTTP_ERROR_NAME] ? attributes[SemanticAttributes.HTTP_ERROR_NAME] : ''}`);this.transaction.addErrors(error);}
if(sps.events&&Array.isArray(sps.events))
{sps.events.forEach(evnt=>{if(evnt?.name=='exception')
{let attr=evnt?.attributes;let error=new proto.org.nudge.buffer.Error();error.setCode(`${attr['exception.type']}`);error.setStarttime(getTimestamp(sps['startTime']));error.setMessage(attr['exception.message']);error.setStacktrace(attr['exception.stacktrace'].replace(/\n\s*at\s*/igm,'#'));error.setJvmstacktrace(attr['exception.stacktrace'].replace(/\n/gm,'\r\n\t'));this.transaction.addErrors(error);}});}
if(typeof attributes[SemanticAttributes.HTTP_ERROR_NAME]!='undefined'||typeof attributes[SemanticAttributes.HTTP_ERROR_MESSAGE]!='undefined')
this.transaction.setStatus(proto.org.nudge.buffer.Transaction.Status.KO);else if(typeof attributes[SemanticAttributes.HTTP_STATUS_CODE]!='undefined')
{if(parseInt(attributes[SemanticAttributes.HTTP_STATUS_CODE])>=400)
this.transaction.setStatus(proto.org.nudge.buffer.Transaction.Status.KO);}
else
{let status=this.transaction.getStatus();this.transaction.setStatus(sps.status.code!==0?proto.org.nudge.buffer.Transaction.Status.KO:status);}
if(typeof attributes[SemanticAttributes.HTTP_METHOD]!='undefined')
this.transaction.setMethodname(attributes[SemanticAttributes.HTTP_METHOD]);if(typeof attributes[SemanticAttributes.HTTP_USER_AGENT]!='undefined')
{this.transaction.setUseragent(attributes[SemanticAttributes.HTTP_USER_AGENT]);let ua=this.rawdata.getUseragent();if(ua==undefined)
{let userAgentDictionary=new proto.org.nudge.buffer.Dictionary();this.rawdata.setUseragent(userAgentDictionary);ua=userAgentDictionary;}
if(ua)
{if(!ua.array[0].map(e=>e[0]).includes(attributes[SemanticAttributes.HTTP_USER_AGENT]))
{let id=ua.array[0].length;let aEntry=new proto.org.nudge.buffer.Dictionary.DictionaryEntry();aEntry.setName(attributes[SemanticAttributes.HTTP_USER_AGENT]);aEntry.setId(id);ua.addDictionary(aEntry);this.transaction.setUseragentid(id);}
else
{let dua=ua.array[0].find(e=>e[0]==attributes[SemanticAttributes.HTTP_USER_AGENT]);this.transaction.setUseragentid(dua[1]);}}}
if(global.configurationAgentNodeJS?.NodeJS?.profilerV8===true)
{global.inspector.profile.addSpan(new global.SpanTAB(sps));let r=this.DataProfilerToRawdata(dataAnalyseDataProfilers);r.foundCallOriginal_ATK.forEach((e,i)=>{functionPointEntreeTimeLineNodes[i].N+=e.N;functionPointEntreeTimeLineNodes[i].M=e.M;});}
if(typeof attributes[SemanticAttributes.HTTP_ROUTE]!='undefined'&&sps.name&&sps.name.includes(attributes[SemanticAttributes.HTTP_ROUTE]))
{if(this.transaction.getTxtype()==""&&INSTRUMENT)
{this.transaction.setTxtype(toUpperCase1.call(INSTRUMENT));this.transaction.TAG.serveur=this.transaction.TAG.serveur==undefined?new Serveur():this.transaction.TAG.serveur;this.transaction.TAG.serveur.instrument=INSTRUMENT;}
if(SERVEUR)
{this.transaction.TAG.serveur=this.transaction.TAG.serveur==undefined?new Serveur():this.transaction.TAG.serveur;this.transaction.TAG.serveur.name=attributes[`${SERVEUR}.name`];this.transaction.TAG.serveur.type=attributes[`${SERVEUR}.type`];this.transaction.TAG.serveur.nom=SERVEUR;}
if(global.configurationAgentNodeJS?.NodeJS?.waitEndService===true)
this.transaction.TAG.urlid=sps.parentSpanId!=undefined?1:0;else
this.transaction.TAG.urlid=0;}}else if(HTTP&&(sps.kind===2||sps.parentSpanId!=undefined))
{if(sps.parentSpanId==undefined)
{if(typeof attributes[SemanticAttributes.HTTP_ROUTE]!='undefined')
this.transaction.setUrl(attributes[SemanticAttributes.HTTP_ROUTE]);this.transaction.TAG.urlid=0;}
let urlX="";if(typeof attributes[SemanticAttributes.NET_PEER_NAME]!='undefined')
urlX=`${attributes[SemanticAttributes.NET_PEER_NAME]}`+(typeof attributes[SemanticAttributes.NET_PEER_PORT]!='undefined'?`:${attributes[SemanticAttributes.NET_PEER_PORT]}`:``);else if(typeof attributes[SemanticAttributes.NET_PEER_IP]!='undefined')
urlX=`${attributes[SemanticAttributes.NET_PEER_IP]}`+(typeof attributes[SemanticAttributes.NET_PEER_PORT]!='undefined'?`:${attributes[SemanticAttributes.NET_PEER_PORT]}`:``);urlX=urlX.split(/:\/\//gm,2);urlX=urlX[0].split(/:|\//gm,2);let layerType=SemanticAttributes.LAYER_TYPE_HTTP;let layerHTTP=this.transaction.getLayersList().find(l=>{return l.getLayername()==layerType;});if(layerHTTP==undefined)
{layerHTTP=new proto.org.nudge.buffer.Layer();this.transaction.addLayers(layerHTTP);layerHTTP.setLayername(layerType);}
layerHTTP.setCount(layerHTTP.getCount()+1);let layerDetail=new proto.org.nudge.buffer.LayerDetail();if(sps['status']!=undefined&&sps['status']['code']===1&&(attributes[SemanticAttributes.HTTP_STATUS_CODE]==undefined||attributes[SemanticAttributes.HTTP_STATUS_CODE]>=400))
{let error=new proto.org.nudge.buffer.Error();error.setCode(sps.status.code.toString());error.setStarttime(getTimestamp(sps['startTime']));if(typeof sps['status']['message']!='undefined')
error.setMessage((attributes[SemanticAttributes.HTTP_URL].length>30?attributes[SemanticAttributes.HTTP_URL].substring(0,40)+'...':attributes[SemanticAttributes.HTTP_URL])
+' : '+sps['status']['message']);if(typeof attributes[SemanticAttributes.HTTP_STACKTRACE]!='undefined')
{let err=attributes[SemanticAttributes.HTTP_STACKTRACE].join('\n');error.setStacktrace(err.replace(/\n\s*at\s*/igm,'#'));error.setJvmstacktrace(err.replace(/\n/gm,'\r\n\t'));}
this.transaction.setStatus(proto.org.nudge.buffer.Transaction.Status.KO);this.transaction.addErrors(error);layerHTTP.setErrors(layerHTTP.getErrors()+1);layerDetail.setErrors(1);}
else
{layerDetail.setErrors(0);}
if(typeof attributes[SemanticAttributes.HTTP_URL]!='undefined')
layerDetail.setCode(attributes[SemanticAttributes.HTTP_URL]);let st=getTimestamp(sps['startTime']);let stOLD=this.transaction.getStarttime();let et=getTimestamp(sps['endTime']);let etOLD=this.transaction.getEndtime();if(stOLD==0)
this.transaction.setStarttime(st);if(etOLD==0)
this.transaction.setEndtime(et);layerDetail.setTimestamp(getTimestamp(sps['startTime']));let time=getTimestamp(sps['endTime'])-getTimestamp(sps['startTime']);layerDetail.setTime(time);layerDetail.setCount(layerDetail.getCount()+1);if(typeof attributes[SemanticAttributes.HTTP_TARGET]!='undefined')
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey(SemanticAttributes.HTTP_TARGET);keyValue.setValue(attributes[SemanticAttributes.HTTP_TARGET]);layerDetail.addExtcodes(keyValue);}
if(typeof attributes[SemanticAttributes.HTTP_STATUS_TEXT]!='undefined')
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("http.status_text");keyValue.setValue(attributes[SemanticAttributes.HTTP_STATUS_TEXT]);layerDetail.addExtcodes(keyValue);}
if(typeof attributes[SemanticAttributes.HTTP_FLAVOR]!='undefined')
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("http.flavor");keyValue.setValue(attributes[SemanticAttributes.HTTP_FLAVOR]);layerDetail.addExtcodes(keyValue);}
if(typeof attributes[SemanticAttributes.HTTP_METHOD]!='undefined')
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("http.method");keyValue.setValue(attributes[SemanticAttributes.HTTP_METHOD]);layerDetail.addExtcodes(keyValue);}
if(typeof attributes[SemanticAttributes.NET_PEER_NAME]!='undefined')
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("net.peer.name");keyValue.setValue(attributes[SemanticAttributes.NET_PEER_NAME]);layerDetail.addExtcodes(keyValue);}
if(typeof attributes[SemanticAttributes.NET_PEER_PORT]!='undefined')
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("net.peer.port");keyValue.setValue(attributes[SemanticAttributes.NET_PEER_PORT].toString());layerDetail.addExtcodes(keyValue);}
layerHTTP.addCalls(layerDetail);}else if(DB||GQL)
{if(sps.parentSpanId==undefined)
{this.transaction.setUrl(sps.name);this.transaction.TAG.urlid=0;}
let layerType=SemanticAttributes.LAYER_TYPE_SQL;let layerSQL=this.transaction.getLayersList().find(l=>{return l.getLayername()==layerType;});if(layerSQL==undefined)
{layerSQL=new proto.org.nudge.buffer.Layer();this.transaction.addLayers(layerSQL);layerSQL.setLayername(layerType);}
layerSQL.setCount(layerSQL.getCount()+1);layerSQL.setLayername(SemanticAttributes.LAYER_TYPE_SQL);let layerDetail=new proto.org.nudge.buffer.LayerDetail();if(sps['status']!=undefined&&sps['status']['code']===2)
{let error=new proto.org.nudge.buffer.Error();error.setCode(`SQL - ${attributes[SemanticAttributes.DB_SYSTEM]}`);error.setStarttime(getTimestamp(sps['startTime']));if(typeof sps['status']['message']!='undefined')
error.setMessage((attributes[SemanticAttributes.DB_STATEMENT]?.length>30?attributes[SemanticAttributes.DB_STATEMENT].substring(0,40)+'...':attributes[SemanticAttributes.DB_STATEMENT])
+' : '+sps['status']['message']);if(typeof attributes[SemanticAttributes.HTTP_STACKTRACE]!='undefined')
{let err=attributes[SemanticAttributes.HTTP_STACKTRACE].join('\n');error.setStacktrace(err.replace(/\n\s*at\s*/igm,'#'));error.setJvmstacktrace(err.replace(/\n/gm,'\r\n\t'));}
this.transaction.setStatus(proto.org.nudge.buffer.Transaction.Status.KO);this.transaction.addErrors(error);layerSQL.setErrors(layerSQL.getErrors()+1);layerDetail.setErrors(1);}
else
{layerDetail.setErrors(0);}
if(typeof attributes[SemanticAttributes.DB_STATEMENT]!='undefined')
layerDetail.setCode(attributes[SemanticAttributes.DB_STATEMENT]);let st=getTimestamp(sps['startTime']);let stOLD=this.transaction.getStarttime();let et=getTimestamp(sps['endTime']);let etOLD=this.transaction.getEndtime();if(stOLD==0)
this.transaction.setStarttime(st);if(etOLD==0)
this.transaction.setEndtime(et);layerDetail.setTimestamp(getTimestamp(sps['startTime']));var time=getTimestamp(sps['endTime'])-getTimestamp(sps['startTime']);layerDetail.setTime(time);layerDetail.setCount(1);switch(INSTRUMENT){case"Graphql":{if(typeof attributes['graphql.operation.type']!='undefined')
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("jdbc.name");keyValue.setValue(`${INSTRUMENT}_${attributes['graphql.operation.type']}`);layerDetail.addExtcodes(keyValue);let connection_string=`jdbc:${INSTRUMENT.toLowerCase()}://`;keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("jdbc.url");keyValue.setValue(connection_string);layerDetail.addExtcodes(keyValue);keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey(SemanticAttributes.DB_STATEMENT);keyValue.setValue(attributes['graphql.source']);layerDetail.addExtcodes(keyValue);keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("jdbc.product.user");keyValue.setValue(attributes['graphql.operation.type']);layerDetail.addExtcodes(keyValue);}else{if(typeof attributes['graphql.source']!='undefined')
{let extCodes=layerDetail.getExtcodesList();let kv=extCodes.find(e=>e==SemanticAttributes.DB_SYSTEM)
if(!kv){let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey(SemanticAttributes.DB_SYSTEM);keyValue.setValue(INSTRUMENT.toLowerCase());layerDetail.addExtcodes(keyValue);}else{}
let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey(SemanticAttributes.DB_STATEMENT);keyValue.setValue(attributes['graphql.source']);}}
layerSQL.addCalls(layerDetail);}
break;default:{if(typeof attributes[SemanticAttributes.DB_CONNECTION_STRING]!='undefined')
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("jdbc.url");let connection_string=attributes[SemanticAttributes.DB_CONNECTION_STRING];if(global.configurationAgentNodeJS?.NodeJS?.sendUserConnectionString===true)
connection_string=connection_string.replace('://',`${attributes[SemanticAttributes.DB_USER]?.length > 0 ? '://'+attributes[SemanticAttributes.DB_USER]+'@' : '://' }`);keyValue.setValue(connection_string);layerDetail.addExtcodes(keyValue);}
else
if(typeof attributes[SemanticAttributes.DB_MONGODB_COLLECTION]!='undefined')
{let connection_string=`${attributes[SemanticAttributes.DB_SYSTEM]}://${attributes[SemanticAttributes.NET_HOST_NAME]}:${attributes[SemanticAttributes.NET_HOST_PORT]}/${attributes[SemanticAttributes.DB_MONGODB_COLLECTION]}`;if(global.configurationAgentNodeJS?.NodeJS?.sendUserConnectionString===true)
connection_string=connection_string.replace('://',`${attributes[SemanticAttributes.DB_NAME]?.length > 0 ? '://'+attributes[SemanticAttributes.DB_NAME]+'@' : '://' }`);let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("jdbc.url");keyValue.setValue(connection_string);layerDetail.addExtcodes(keyValue);}else
if(typeof attributes[SemanticAttributes.DB_SYSTEM]=='string')
{switch(attributes[SemanticAttributes.DB_SYSTEM].toLowerCase())
{case'sqlite':case'sqlite3':{let connection_string=`${attributes[SemanticAttributes.DB_SYSTEM]}///${attributes[SemanticAttributes.DB_NAME]}`;if(global.configurationAgentNodeJS?.NodeJS?.sendUserConnectionString===true)
connection_string=connection_string.replace('://',`${attributes[SemanticAttributes.DB_USER]?.length > 0 ? '://'+attributes[SemanticAttributes.DB_USER]+'@' : '://' }`);let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("jdbc.url");keyValue.setValue(connection_string);layerDetail.addExtcodes(keyValue);}
break;case'cassandra':{let connection_string=`${attributes[SemanticAttributes.DB_SYSTEM]}://${attributes[SemanticAttributes.NET_PEER_NAME]}${attributes[SemanticAttributes.NET_PEER_PORT] != undefined ? ':':''}${attributes[SemanticAttributes.NET_PEER_PORT]}/${attributes[SemanticAttributes.DB_NAME]}`;if(global.configurationAgentNodeJS?.NodeJS?.sendUserConnectionString===true)
connection_string=connection_string.replace('://',`${attributes[SemanticAttributes.DB_USER]?.length > 0 ? '://'+attributes[SemanticAttributes.DB_USER]+'@' : '://' }`);let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("jdbc.url");keyValue.setValue(connection_string);layerDetail.addExtcodes(keyValue);}
break;default:{let connection_string=`${attributes[SemanticAttributes.DB_SYSTEM]}://${attributes[SemanticAttributes.NET_PEER_NAME]}${attributes[SemanticAttributes.NET_PEER_PORT] != undefined ? ':':''}${attributes[SemanticAttributes.NET_PEER_PORT]}/${attributes[SemanticAttributes.DB_NAME]}`;if(global.configurationAgentNodeJS?.NodeJS?.sendUserConnectionString===true)
connection_string=connection_string.replace('://',`${attributes[SemanticAttributes.DB_USER]?.length > 0 ? '://'+attributes[SemanticAttributes.DB_USER]+'@' : '://' }`);let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("jdbc.url");keyValue.setValue(connection_string);layerDetail.addExtcodes(keyValue);}
break;}}
if(typeof attributes[SemanticAttributes.DB_NAME]!='undefined')
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("jdbc.name");keyValue.setValue(attributes[SemanticAttributes.DB_NAME]);layerDetail.addExtcodes(keyValue);}
if(typeof attributes[SemanticAttributes.DB_SYSTEM]!='undefined')
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("jdbc.system");keyValue.setValue(attributes[SemanticAttributes.DB_SYSTEM]);layerDetail.addExtcodes(keyValue);}
if(typeof attributes[SemanticAttributes.DB_USER]!='undefined')
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("jdbc.product.user");keyValue.setValue(attributes[SemanticAttributes.DB_USER]);layerDetail.addExtcodes(keyValue);}
let SA=[SemanticAttributes.NET_PEER_NAME,SemanticAttributes.NET_PEER_PORT,SemanticAttributes.NET_HOST_NAME,SemanticAttributes.NET_HOST_PORT,];let SAN=[SemanticAttributes.DB_USER,SemanticAttributes.DB_SYSTEM,SemanticAttributes.DB_NAME,SemanticAttributes.DB_SYSTEM,SemanticAttributes.DB_MONGODB_COLLECTION,SemanticAttributes.DB_CONNECTION_STRING,SemanticAttributes.DB_STATEMENT,SemanticAttributes.HTTP_STACKTRACE,SemanticAttributes.LAYER_TYPE_SQL,];for(let k in attributes){if(!SAN.includes(k))
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey(k);keyValue.setValue(attributes[k]);layerDetail.addExtcodes(keyValue);}};layerSQL.addCalls(layerDetail);}}}}
this.sendTransaction();if(global.configurationAgentNodeJS?.Console?.logDetail2===true)
{let functionPointEntreeTimeLineNode=getLast(functionPointEntreeTimeLineNodes);let T=functionPointEntreeTimeLineNodes.reduce((a,e)=>a+e.N,0);let s='['+functionPointEntreeTimeLineNodes.reduce((a,e,i)=>{return a+`${e.N}(${e.M})[${functionPointEntreeTimeLineNode.I - e.I}]${i+1 < functionPointEntreeTimeLineNodes.length ? ',':''}`;},"")+']';MyConsole.log(`going to flush rawdata -> global.inspector.profile.cmpt / functionPointEntreeTimeLineNodes -> ${global.inspector.profile.cmpt} / ${T} ${s}} : (${global.inspector.profile.cmpt == T ? "OK" : "KO"})`);}
global.inspector.profile.cmpt=0;this.flushRawdata();}
this.getNameType=function(attributes)
{let keys=Object.keys(attributes);let kNames=keys.reduce((a,e)=>{if(e.endsWith('.name'))a.push(e.replace('.name',''));return a;},new Array());let kTypes=keys.reduce((a,e)=>{if(e.endsWith('.type'))a.push(e.replace('.type',''));return a;},new Array());let name=kNames.find(t=>kTypes.find(u=>u==t));return name;}
this.getInstrumentType=function(sps)
{if(typeof sps['instrumentationLibrary']!='undefined'&&typeof sps['instrumentationLibrary'].name!='undefined')
{let name=sps['instrumentationLibrary']['name'];let names=name.split('/');if(names.length>=2)
{names=names[1].split('-');names.shift();name=names.join('-');name=toUpperCase1.call(name);return name;}}
return undefined;}
this.addAllExtendedcodes=function(sps)
{let attributesX=sps.attributes;let keyValues=this.transaction.getExtendedcodesList();if(keyValues.findIndex(e=>e.getKey()=="http.method")<0&&typeof attributesX[SemanticAttributes.HTTP_METHOD]!='undefined')
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("http.method");keyValue.setValue(attributesX[SemanticAttributes.HTTP_METHOD]);this.transaction.addExtendedcodes(keyValue);}
let filterHeader=JSON.parse(global.configurationAgentNodeJS?.NodeJS?.filterHeader);let headers=['http.request.header.','http.response.header.'];Object.keys(sps.attributes).forEach(att=>{headers.forEach(header=>{if(att.startsWith(header)&&(!Array.isArray(filterHeader)||filterHeader.length==0||filterHeader.indexOf(e=>header.toLowerCase()==e.toLowerCase())>=0))
{let keyValue=new proto.org.nudge.buffer.KeyValue();let headKey=att.substring(header.length);let headKeys=headKey.split('_').map(e=>toUpperCase1.call(e))
headKey=header+headKeys.join('-');if(keyValues.findIndex(e=>e.getKey()==headKey)<0)
{keyValue.setKey(headKey);keyValue.setValue(Array.isArray(attributesX[att])?attributesX[att][0].toString():attributesX[att].toString());this.transaction.addExtendedcodes(keyValue);}
if(att.includes('user_agent'))
{let browserInfo=browser.parse(sps.attributes[att][0].toString());if(browserInfo)
{if(browserInfo.browser&&browserInfo.browser.name)
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey('Environnement.Navigateur');keyValue.setValue(`${browserInfo.browser.name} ${browserInfo.browser.version}`);this.transaction.addExtendedcodes(keyValue);}
if(browserInfo.os&&browserInfo.os.name)
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey('Environnement.OS');keyValue.setValue(`${browserInfo.os.name} ${browserInfo.os.versionName}`);this.transaction.addExtendedcodes(keyValue);}
if(browserInfo.platform&&browserInfo.platform.type)
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey('Environnement.Platform');keyValue.setValue(browserInfo.platform.type);this.transaction.addExtendedcodes(keyValue);}
if(browserInfo.engine&&browserInfo.engine.name)
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey('Environnement.Engine');keyValue.setValue(browserInfo.engine.name);this.transaction.addExtendedcodes(keyValue);}}}}});});if(keyValues.findIndex(e=>e.getKey()=="http.clientip")<0&&typeof attributesX[SemanticAttributes.NET_PEER_IP]!='undefined')
{let clientip=attributesX[SemanticAttributes.NET_PEER_IP].toString();let rgx=/:(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/gm;let m=clientip.match(rgx);if(Array.isArray(m)){let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("http.clientip");keyValue.setValue(m[0].substring(1));this.transaction.addExtendedcodes(keyValue);this.transaction.setUserip(m[0].substring(1));keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("http.clientip6");keyValue.setValue(clientip.substring(0,clientip.length-m[0].length));this.transaction.addExtendedcodes(keyValue);}else{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("http.clientip");keyValue.setValue(attributesX[SemanticAttributes.NET_PEER_IP].toString());this.transaction.addExtendedcodes(keyValue);this.transaction.setUserip(attributesX[SemanticAttributes.NET_PEER_IP].toString());}}
if(keyValues.findIndex(e=>e.getKey()=="http.status")<0&&typeof attributesX[SemanticAttributes.HTTP_STATUS_CODE]!='undefined')
{let keyValue=new proto.org.nudge.buffer.KeyValue();keyValue.setKey("http.status");keyValue.setValue(attributesX[SemanticAttributes.HTTP_STATUS_CODE].toString());this.transaction.addExtendedcodes(keyValue);}}
this.DataProfilerToRawdata=function(aDataProfilerS)
{let foundCallOriginal_ATK=new Array(aDataProfilerS.length);foundCallOriginal_ATK.fill({N:0,M:0,I:0},0);let nomFunctionSpanX=new Array();global.inspector.profile.spanTABs.forEach((spsTABX,iSpsTABX)=>{let spsX=spsTABX.span;let nameFunction=global.inspector.profile.getFunctionNameCalloriginalATK(spsX._spanContext);for(let iaDataProfiler=aDataProfilerS.length-1;iaDataProfiler>=0;iaDataProfiler--)
{let aDataProfiler=aDataProfilerS[iaDataProfiler];if(aDataProfiler!=undefined)
{let indexes_callOriginal_ATK_=findIndexes.call(aDataProfiler.analyseDataProfiler.dataProfiler.nodes,e=>e.callFrame.functionName==nameFunction);if(indexes_callOriginal_ATK_.length>0)
indexes_callOriginal_ATK_.forEach(index_callOriginal_ATK_=>{let classDictionary=this.rawdata.getClassdictionary();let methodDictionary=this.rawdata.getMethoddictionary();let spanAttributes=spsX['attributes'];let uuid=spanAttributes[SemanticAttributes.UUID]?spanAttributes[SemanticAttributes.UUID]:generateUUID.Null;spsTABX.mustDeleted=true;foundCallOriginal_ATK[iaDataProfiler].N++;nomFunctionSpanX.push(nameFunction);let treeTimesLinesNodesChildren;if(global.configurationAgentNodeJS.Profiler.pointEntreeClientOnly)
treeTimesLinesNodesChildren=aDataProfiler.analyseDataProfiler.getTreeNodesChildren(aDataProfiler.analyseDataProfiler.dataProfiler.nodes[index_callOriginal_ATK_]);else
treeTimesLinesNodesChildren=aDataProfiler.analyseDataProfiler.treeProfiles;treeTimesLinesNodesChildren.forEach(treeTimeLineNodesChildren=>{let threadInfos=new proto.org.nudge.buffer.ThreadInfo();threadInfos.clearFramesList();treeTimeLineNodesChildren.nodes.forEach(treeTimeLineNodesChild=>{let[functionName,className]=getClFn(treeTimeLineNodesChild.callFrame.functionName);threadInfos.setUuid(uuid);let url=treeTimeLineNodesChild.callFrame.url;threadInfos.setUrl(url);threadInfos.setState(proto.org.nudge.buffer.ThreadInfo.State.RUNNABLE);let frameMain=new proto.org.nudge.buffer.ThreadInfo.StackTraceElement();if(!classDictionary.array[0].map(e=>e[0]).includes(className))
{let classDictionaryEntry=new proto.org.nudge.buffer.Dictionary.DictionaryEntry();classDictionaryEntry.setName(className);classDictionaryEntry.setId(classDictionary.array[0].length);classDictionary.addDictionary(classDictionaryEntry);}
if(!methodDictionary.array[0].map(e=>e[0]).includes(functionName))
{let methodDictionaryEntry=new proto.org.nudge.buffer.Dictionary.DictionaryEntry();methodDictionaryEntry.setName(functionName);methodDictionaryEntry.setId(methodDictionary.array[0].length);methodDictionary.addDictionary(methodDictionaryEntry);}
frameMain.setMethodname(functionName);frameMain.setClassname(className);frameMain.setLinenumber(treeTimeLineNodesChild.callFrame.lineNumber);let cd=classDictionary.array[0].find(cl=>cl[0]==className);frameMain.setClassnameid(cd[1]);let md=methodDictionary.array[0].find(me=>me[0]==functionName);frameMain.setMethodnameid(md[1]);threadInfos.addFrames(frameMain);});threadInfos.setBlockedtime(-1);threadInfos.setBlockedcount(0);threadInfos.setWaitedtime(-1);threadInfos.setWaitedcount(0);let frames=threadInfos.getFramesList();let timeStamp=parseInt(this.transaction.getStarttime()+treeTimeLineNodesChildren.startTime/1000);threadInfos.setTimestamp(timeStamp);try
{if(frames.length>0)
{let[functionName,className]=[frames[frames.length-1].getMethodname(),frames[frames.length-1].getClassname()];threadInfos.setUrl(`${className}${(className != '' ? '.' : '') + functionName}`);}}
catch(e)
{MyConsole.log(`Profiling : ${e.message}`);}
for(let i=0;i<treeTimeLineNodesChildren.nTime;i++)
{this.rawdata.addThreadinfos(threadInfos);}});this.rawdata.setMethoddictionary(methodDictionary);this.rawdata.setClassdictionary(classDictionary);aDataProfiler.analyseDataProfiler.dataProfiler.nodes[index_callOriginal_ATK_].callFrame.functionName+="_DELETED";aDataProfiler.analyseDataProfiler.numberCallOrigin--;foundCallOriginal_ATK[iaDataProfiler].M=aDataProfiler.analyseDataProfiler.numberCallOrigin;});else
{spsTABX.profileNotFound=true;}
function getClFn(s)
{let x=s.split('.');let functionName=x.length>0?x.pop():global.configurationAgentNodeJS?.NodeJS?.UnknownFunction;functionName=functionName==''?global.configurationAgentNodeJS?.NodeJS?.UnknownFunction:functionName;let className=x.length>0?x.join('.'):'';className=className==''?global.configurationAgentNodeJS?.NodeJS?.UnknownClass:className;return[functionName,className];}}}});for(let iaDataProfiler=aDataProfilerS.length-1;iaDataProfiler>=0;iaDataProfiler--)
{let aDataProfiler=aDataProfilerS[iaDataProfiler];if(aDataProfiler!=undefined)
{if(aDataProfiler.analyseDataProfiler.numberCallOrigin==0)
{aDataProfilerS.splice(iaDataProfiler,1);}}}
let rr=global.inspector.profile.spanTABs.length;let r=global.inspector.profile.refreshSpanTABs();if(r>0)
if(global.configurationAgentNodeJS.Console.logDetail===true)
MyConsole.log(`SpanTABs deleted ${r}/${rr}`);return{foundCallOriginal_ATK:foundCallOriginal_ATK,nomFunctionSpanX:nomFunctionSpanX};}
this.sendTransaction=function()
{for(let i=0;i<this.transactions.length;i++)
{let t=this.transactions[i];if([0,2].includes(t.TAG.urlid))
{if([0].includes(t.TAG.urlid))
this.rawdata.addTransactions(t);this.transactions.splice(i,1);i--;}else if([1].includes(t.TAG.urlid))
{let st=t.getStarttime();st=(Date.now()-st)/1000;if(st>0&&st>global.configurationAgentNodeJS?.nodeJS?.timeoutBufferTransaction)
{if(global.configurationAgentNodeJS?.Console?.logDetail2===true)
MyConsole.log(`Transaction non terminée(s) TIMEOUT : ${t.getUrl()}`);this.rawdata.addTransactions(t);this.transactions.splice(i,1);i--;}}}
if(global.configurationAgentNodeJS?.Console?.logDetail2===true)
MyConsole.log(`Nombre de transaction(s) non terminée(s) : ${this.transactions.length}`);this.transaction=undefined;}
this.flushRawdata=function()
{if(this.rawdata==undefined)
return;let transactions=this.rawdata.getTransactionsList();if(transactions.length>0)
{let binary=this.rawdata.serializeBinary();if(global.configurationAgentNodeJS?.NodeJS?.recordCollecte===true)
{let d=new Date();let dateStr="X";let filename=path.resolve(__dirname,`./collectes/collecte_${dateStr}_${filename_N}.dat`);fs.writeFile(filename,binary,()=>{});filename_N++;}
if(typeof request[this._method]=='function')
{const options={uri:this._url,body:binary,headers:this._headers,timeout:this._exportimeoutMillis,};let dNudge=Date.now();let This=this;request[this._method](options,function(err,res,body){if(err!=undefined)
MyConsole.log(`Reponse de la requete ${options.uri} ${This._method.toUpperCase()} vers NUDGE ERR  ${Date.now()-dNudge}ms ${parseInt(binary.length/1024)}Ko : ${res ? res.statusCode : ""} : ${err}`);else
MyConsole.log(`Reponse de la requete ${options.uri} ${This._method.toUpperCase()} vers NUDGE BODY ${Date.now()-dNudge}ms ${parseInt(binary.length/1024)}Ko : ${res ? res.statusCode : ""} : ${body}`);});}
else
{MyConsole.log("");}
this.reset();this.rawdata=undefined;}}
this.indexRawdata=0;this.createRawdata=function()
{let service_hostname=`${global.configurationAgentNodeJS?.NodeJS?.prefixeServiceName.length > 0 ? global.configurationAgentNodeJS?.NodeJS?.prefixeServiceName+' ' : ''}${os.hostname()}`;service_hostname=service_hostname.replace(/\s/gm,'_');if(this.rawdata==undefined)
{this.rawdata=new proto.org.nudge.buffer.RawData();this.rawdata.clearServerconfig();this.rawdata.clearThreadinfosList();this.rawdata.clearSystemmetricsList();this.rawdata.clearClassdictionary();this.rawdata.clearMethoddictionary();this.rawdata.clearThreadactivity();this.rawdata.setId(this._cmpt++);this.rawdata.setAgentid(this._Agentiduuid);this.rawdata.setHostname(service_hostname);const hash=crypto.createHash("md5").update(service_hostname).digest("hex");const bigInt=BigInt(`0x${hash.substring(0, 16)}`);const signed64=BigInt.asIntN(64,bigInt);let hostkey=Number(signed64);this.rawdata.setHostkey(hostkey);if(indexRawdata_MIN==-1||this.indexRawdata<indexRawdata_MIN)
{let serverConfig=new proto.org.nudge.buffer.ServerConfig();serverConfig.setOsarch(os.arch());serverConfig.setOsname(os.version());serverConfig.setOsversion(os.release());let cpus=os.cpus();serverConfig.setAvailableprocessors(cpus.length);serverConfig.setVmname(`NodeJS@${os.hostname}`);serverConfig.setVmvendor(pjson.vendor);let versions=Object.keys(process.versions).map(e=>`${e}@${process.versions[e]}`).join(';');serverConfig.setVmversion(versions);serverConfig.setServletcontextname(pjson.name);serverConfig.setStarttime(Date.now());serverConfig.setBootclasspath(path.resolve(__dirname,appJS));if(Array.isArray(this.dns))
serverConfig.setCanonicalhostname(this.dns.reduce((a,e)=>{a+=e.addresses.join(';');return a;},""));serverConfig.setHostname(service_hostname);serverConfig.setAppname(global.configurationAgentNodeJS?.NodeJS?.applicationName);let platform=os.platform();serverConfig.setEnvironment(platform.toString());serverConfig.setServername(global.configurationAgentNodeJS?.NodeJS?.applicationName);serverConfig.setServerinfo(pjson.description);serverConfig.setServerport(process.debugPort);serverConfig.setInputarguments(process.argv.join(';'));serverConfig.setNudgeversion(pjson.version);let jvmInfo=new proto.org.nudge.buffer.JvmInfo();jvmInfo.setHostname(service_hostname);let kvs=new Array();if(this?.resourceOTEL?.autoInstrumentations!=undefined)
{this.resourceOTEL.autoInstrumentations.forEach(otel=>{let kv=new proto.org.nudge.buffer.KeyValue();kv.setKey(otel.nom);kv.setValue(otel.version);kvs.push(kv);});}
for(let k in process.env)
{let v=process.env[k];let kv=new proto.org.nudge.buffer.KeyValue();kv.setKey(k);kv.setValue(v);kvs.push(kv);}
jvmInfo.setSystempropertiesList(kvs);serverConfig.setJvminfo(jvmInfo);this.rawdata.setServerconfig(serverConfig);}
let classDictionary=new proto.org.nudge.buffer.Dictionary();let methodDictionary=new proto.org.nudge.buffer.Dictionary();this.rawdata.setMethoddictionary(methodDictionary);this.rawdata.setClassdictionary(classDictionary);getAlldrivesX.call(this);function getAlldrivesX()
{let systemMetricSample=new proto.org.nudge.buffer.SystemMetricSample();let dateNow=Date.now();systemMetricSample.setKey(`mem.free`);systemMetricSample.setTimestamp(dateNow);systemMetricSample.setLongvalue(os.freemem());this.rawdata.addSystemmetrics(systemMetricSample);systemMetricSample=new proto.org.nudge.buffer.SystemMetricSample();systemMetricSample.setKey(`mem.total`);systemMetricSample.setTimestamp(dateNow);systemMetricSample.setLongvalue(os.totalmem());this.rawdata.addSystemmetrics(systemMetricSample);if(oSU.dateNow)
{systemMetricSample=new proto.org.nudge.buffer.SystemMetricSample();systemMetricSample.setKey(`cpu.load`);systemMetricSample.setTimestamp(oSU.dateNow);systemMetricSample.setDoublevalue(oSU.cpuPercentage/100);this.rawdata.addSystemmetrics(systemMetricSample);systemMetricSample=new proto.org.nudge.buffer.SystemMetricSample();systemMetricSample.setKey(`load`);systemMetricSample.setTimestamp(oSU.dateNow);systemMetricSample.setDoublevalue(oSU.cpuPercentageNode);this.rawdata.addSystemmetrics(systemMetricSample);}
let memoryUsage=process.memoryUsage();if(memoryUsage.external)
{systemMetricSample=new proto.org.nudge.buffer.SystemMetricSample();systemMetricSample.setKey(`swap.free`);systemMetricSample.setTimestamp(dateNow);systemMetricSample.setLongvalue(memoryUsage.rss-memoryUsage.external);this.rawdata.addSystemmetrics(systemMetricSample);}
if(memoryUsage.rss)
{systemMetricSample=new proto.org.nudge.buffer.SystemMetricSample();systemMetricSample.setKey(`swap.total`);systemMetricSample.setTimestamp(dateNow);systemMetricSample.setLongvalue(memoryUsage.rss);this.rawdata.addSystemmetrics(systemMetricSample);}
if(oSU.openFd!="not supported")
{systemMetricSample=new proto.org.nudge.buffer.SystemMetricSample();systemMetricSample.setKey(`proc.fd.open`);systemMetricSample.setTimestamp(dateNow);systemMetricSample.setLongvalue(oSU.openFd);this.rawdata.addSystemmetrics(systemMetricSample);}
let swap=getSwapSize();systemMetricSample=new proto.org.nudge.buffer.SystemMetricSample();systemMetricSample.setKey(`disk.total#[SWAP]`);systemMetricSample.setTimestamp(dateNow);systemMetricSample.setLongvalue(swap?.total);this.rawdata.addSystemmetrics(systemMetricSample);systemMetricSample=new proto.org.nudge.buffer.SystemMetricSample();systemMetricSample.setKey(`disk.free#[SWAP]`);systemMetricSample.setTimestamp(dateNow);systemMetricSample.setLongvalue(swap?.free);this.rawdata.addSystemmetrics(systemMetricSample);if(this.allDrives)
for(var j=0;j<this.allDrives['drives'].length;j++)
{let drive=this.allDrives['drives'][j];if(drive.device!='[SWAP]'){let key=`disk.total#${drive.device} - partition:${drive.partitionTableType} - isSystem:${drive.isSystem ? 'Oui' : 'Non'} - isUSB:${drive.isUSB ? 'Oui' : 'Non'} - isVirtual:${drive.isVirtual ? 'Oui' : 'Non'} - busType:${drive.busType} - busVersion:${drive.busVersion} - description:${drive.description} - mount(s):${drive.mountpoints.map((e) => e.path).join(',')}`;systemMetricSample=new proto.org.nudge.buffer.SystemMetricSample();systemMetricSample.setKey(key);systemMetricSample.setTimestamp(dateNow);systemMetricSample.setLongvalue(drive.size);this.rawdata.addSystemmetrics(systemMetricSample);for(let i=0;i<drive.mountpoints.length;i++)
{let part=drive.mountpoints[i];let diskSpace=part.path!='[SWAP]'?this.allDrives['drivesSpace'][part.path]:{size:swap.size,free:swap.free};if(diskSpace!=undefined){systemMetricSample=new proto.org.nudge.buffer.SystemMetricSample();systemMetricSample.setKey(`disk.total#${part.path}`);systemMetricSample.setTimestamp(dateNow);systemMetricSample.setLongvalue(diskSpace?.size);this.rawdata.addSystemmetrics(systemMetricSample);systemMetricSample=new proto.org.nudge.buffer.SystemMetricSample();systemMetricSample.setKey(`disk.free#${part.path}`);systemMetricSample.setTimestamp(dateNow);systemMetricSample.setLongvalue(diskSpace?.free);this.rawdata.addSystemmetrics(systemMetricSample);}}}}
let heapMemory=new proto.org.nudge.buffer.HeapMemory();heapMemory.setStarttime(Date.now());heapMemory.setUsed(memoryUsage.heapUsed);heapMemory.setTotal(memoryUsage.heapTotal);heapMemory.setEndtime(Date.now());this.rawdata.setHeapmemory(heapMemory);let threadActivity=new proto.org.nudge.buffer.ThreadActivity();threadActivity.setStarttime(Date.now());threadActivity.setCount(1);threadActivity.setDaemonthreadcount(0);threadActivity.setNewthreadcount(0);let cpuUsage=process.cpuUsage();threadActivity.setCputime(cpuUsage.system);threadActivity.setUsertime(cpuUsage.user);threadActivity.setEndtime(Date.now());this.rawdata.setThreadactivity(threadActivity);this.rawdata.setComponentsList(this.components);let argv=process.argv;function getClientModule(m)
{try
{let rFilename=require.resolve(m);let dir=path.dirname(rFilename);let name=path.basename(rFilename);let dirNodeModules=`${dir}${path.sep}node_modules${path.sep}`;let pj=path.join(dir,"package.json");if(fs.existsSync(pj))
{let component=new proto.org.nudge.buffer.Component();component.setKey(m);component.setFilename(m);pj=require(pj);const ver=pj.version;let maevenComponent=new proto.org.nudge.buffer.MavenComponent();maevenComponent.setVersion(ver);maevenComponent.setArtifactid(name);component.addMavencomponents(maevenComponent);const mfile=fs.readFileSync(m);let sha1sum=crypto.createHash('sha1').update(mfile).digest("hex");component.setFilesha1(sha1sum);this.rawdata.addComponents(component);const deps=pj.dependencies;Object.keys(deps).forEach(dep=>{let component=new proto.org.nudge.buffer.Component();let indexjs=`${dirNodeModules}${dep}${path.sep}index.js`;component.setKey(indexjs);component.setFilename(indexjs);let maevenComponent=new proto.org.nudge.buffer.MavenComponent();maevenComponent.setVersion(deps[dep]);maevenComponent.setArtifactid(indexjs);component.addMavencomponents(maevenComponent);if(fs.existsSync(indexjs))
{const mfile=fs.readFileSync(indexjs);let sha1sum=crypto.createHash('sha1').update(mfile).digest("hex");component.setFilesha1(sha1sum);}
this.rawdata.addComponents(component);});}
else
{if(global.configurationAgentNodeJS.Console.logDetail===true)
MyConsole.log(`Erreur Components : Module not found ${pj}`);}}
catch(e)
{let messages=e.message.split('\n');MyConsole.log(`Erreur Components : ${messages[0]}`);return;}}
this.indexRawdata++;if(this.allDrives)
MyConsole.log(`rawdata created : ${this.allDrives.drives.length} lecteur(s) physique. ${Object.keys(this.allDrives.drivesSpace).length} lecteur(s) logique(s)`);}}}}
export(spans,resultCallback){if(this._stopped)
return resultCallback({code:core.ExportResultCode.FAILED,error:new Error('Exporter has been stopped'),});this._finishedSpans.push(...spans);this.gestionnaireSpans();}
shutdown(){this._stopped=true;this._finishedSpans=[];this._finishedSpansALL=[];return Promise.resolve();}
reset(){this._finishedSpans=[];}
resetALL(){this._finishedSpansALL=[];}
getFinishedSpans(){return this._finishedSpans;}
getFinishedSpansALL(){return this._finishedSpansALL;}}
function getSwapSize(){try{if(osLinux){const output=execSync("free -b").toString();const lines=output.split("\n");const swapLine=lines.find(line=>line.toLowerCase().startsWith("swap"));if(swapLine){const values=swapLine.split(/\s+/);return{total:parseInt(values[1],10),used:parseInt(values[2],10),free:parseInt(values[3],10)};}}}catch(error){MyConsole.error("Impossible de récupérer la SWAP :",error);}
return null;}
function transformDataHeap(dataHeap)
{function Node(){}
function Edge(){}
function Location(){}
class DataHeap
{nodes;edges;locations;constructor(nodes,edges,locations)
{this.nodes=nodes;this.edges=edges;this.locations=locations;};}
let x=new Array();dataHeap.forEach(dh=>{let nodes=compact(Node,dh.nodes,dh.snapshot.meta.node_fields,dh.snapshot.meta.node_types);let edges=compact(Edge,dh.edges,dh.snapshot.meta.edge_fields,dh.snapshot.meta.edge_types);let locations=compactLocation(Location,dh.locations,dh.snapshot.meta.location_fields)
function compact(object_name,data,fields,types)
{let xs=new Array();let iMax=data.length/fields.length;for(let i=0;i<iMax;i++)
{let t=new object_name();for(let j=0;j<fields.length;j++)
{let x=data[i*fields.length+j];if(Array.isArray(types[j]))
Object.defineProperty(t,fields[j],{value:types[j][x],writable:false,enumerable:true,configurable:false});else
switch(types[j])
{case'string':Object.defineProperty(t,fields[j],{value:dh.strings[x],writable:false,enumerable:true,configurable:false});break;case'number':Object.defineProperty(t,fields[j],{value:x,writable:false,enumerable:true,configurable:false});break;default:Object.defineProperty(t,fields[j],{value:x,writable:false,enumerable:true,configurable:false});}}
xs.push(t);}
return xs;}
function compactLocation(object_name,data,fields)
{let xs=new Array();let iMax=data.length/fields.length;for(let i=0;i<iMax;i++)
{let t=new object_name();for(let j=0;j<fields.length;j++)
{let x=data[i*fields.length+j];Object.defineProperty(t,fields[j],{value:x,writable:false,enumerable:true,configurable:false});}
xs.push(t);}
return xs;}
x.push(new DataHeap(edges,nodes,locations));});return x;}
function toDisk(filename,jsnData)
{return new Promise(async(resolve,reject)=>{let jsn=JSON.stringify(jsnData);if(global.configurationAgentNodeJS.Console.logDetail2===true)
MyConsole.log(`Writing to DISK ${new Date().toISOString()} : ${filename}`);fs.writeFile(filename,jsn,(err,f)=>{resolve(filename);});});}
function fromDisk(filename)
{return new Promise(async(resolve,reject)=>{MyConsole.log(`Reading from DISK ${new Date().toISOString()} : ${filename}`);fs.readFile(filename,'utf8',(err,jsn)=>{jsn=JSON.parse(jsn);resolve(jsn);});});}
function getUrl(attributesX)
{if(typeof attributesX[SemanticAttributes.NET_PEER_NAME]!='undefined')
return`${attributesX[SemanticAttributes.NET_PEER_NAME]}`+(typeof attributesX[SemanticAttributes.NET_PEER_PORT]!='undefined'?`:${attributesX[SemanticAttributes.NET_PEER_PORT]}`:``);else if(typeof attributesX[SemanticAttributes.NET_PEER_IP]!='undefined')
return`${attributesX[SemanticAttributes.NET_PEER_IP]}`+(typeof attributesX[SemanticAttributes.NET_PEER_PORT]!='undefined'?`:${attributesX[SemanticAttributes.NET_PEER_PORT]}`:``);else if(typeof attributesX[SemanticAttributes.HTTP_ROUTE]!='undefined'&&attributesX[SemanticAttributes.HTTP_ROUTE]=='/')
return attributesX[SemanticAttributes.HTTP_ROUTE];else if(typeof attributesX[SemanticAttributes.NET_HOST_NAME]!='undefined')
return`${attributesX[SemanticAttributes.NET_HOST_NAME]}`+(typeof attributesX[SemanticAttributes.NET_HOST_PORT]!='undefined'?`:${attributesX[SemanticAttributes.NET_HOST_PORT]}`:``);}
generateUUID.Null='00000000-0000-0000-0000-000000000000';function generateUUID(){let d=new Date().getTime();let d2=((typeof performance!=='undefined')&&performance.now&&(performance.now()*1000))||0;return'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g,function(c){let r=Math.random()*16;if(d>0){r=(d+r)%16|0;d=Math.floor(d/16);}else{r=(d2+r)%16|0;d2=Math.floor(d2/16);}
return(c==='x'?r:(r&0x3|0x8)).toString(16);});}
exports.NudgeExporter={NudgeSpanExporter,transformDataHeap,generateUUID,AnalyseDataProfiler,getLast,setLast};